/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWXmlPrimaryKeyPolicy
extends MWModel
implements MWXmlNode,
MWXpathContext {
    protected List primaryKeys;
    public static final String PRIMARY_KEYS_COLLECTION = "primaryKeys";

    private MWXmlPrimaryKeyPolicy() {
    }

    MWXmlPrimaryKeyPolicy(MWAbstractTransactionalPolicy parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.primaryKeys = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List list = this.primaryKeys;
        synchronized (list) {
            children.addAll(this.primaryKeys);
        }
    }

    public Iterator primaryKeys() {
        return new CloneIterator(this.primaryKeys);
    }

    public int primaryKeysSize() {
        return this.primaryKeys.size();
    }

    public void clearPrimaryKeys() {
        this.primaryKeys.clear();
        this.fireCollectionChanged(PRIMARY_KEYS_COLLECTION);
    }

    public Iterator primaryKeyXpaths() {
        return new TransformationIterator(this.primaryKeys()){

            @Override
            protected Object transform(Object next) {
                return ((MWXmlField)next).getXpath();
            }
        };
    }

    public MWXmlField addPrimaryKey(String xpath) {
        MWXmlField xmlField = this.buildEmptyPrimaryKey();
        xmlField.setXpath(xpath);
        this.addPrimaryKey(xmlField);
        return xmlField;
    }

    public MWXmlField buildEmptyPrimaryKey() {
        return new MWXmlField(this);
    }

    public void addPrimaryKey(MWXmlField xmlField) {
        this.addItemToCollection(xmlField, this.primaryKeys, PRIMARY_KEYS_COLLECTION);
    }

    public void removePrimaryKey(MWXmlField xmlField) {
        this.removeItemFromCollection(xmlField, this.primaryKeys, PRIMARY_KEYS_COLLECTION);
    }

    @Override
    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.xmlDescriptor().getSchemaContext();
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.getParent().getParent();
    }

    @Override
    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            @Override
            public boolean mayUseCollectionData() {
                return false;
            }

            @Override
            public boolean mayUseComplexData() {
                return false;
            }

            @Override
            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    @Override
    public void resolveXpaths() {
        Iterator stream = this.primaryKeys();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).resolveXpaths();
        }
    }

    @Override
    public void schemaChanged(SchemaChange change) {
        Iterator stream = this.primaryKeys();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).schemaChanged(change);
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        Iterator primaryKeys = this.primaryKeys();
        while (primaryKeys.hasNext()) {
            runtimeDescriptor.addPrimaryKeyField(((MWDataField)primaryKeys.next()).runtimeField());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlPrimaryKeyPolicy.class);
        XMLCompositeCollectionMapping primaryKeysMapping = new XMLCompositeCollectionMapping();
        primaryKeysMapping.setReferenceClass(MWXmlField.class);
        primaryKeysMapping.setAttributeName(PRIMARY_KEYS_COLLECTION);
        primaryKeysMapping.setGetMethodName("getPrimaryKeysForTopLink");
        primaryKeysMapping.setSetMethodName("setPrimaryKeysForTopLink");
        primaryKeysMapping.setXPath("primary-keys/xml-field");
        primaryKeysMapping.useCollectionClass(Vector.class);
        descriptor.addMapping((DatabaseMapping)primaryKeysMapping);
        return descriptor;
    }

    private List getPrimaryKeysForTopLink() {
        return CollectionTools.list(this.specifiedPrimaryKeys());
    }

    private Iterator specifiedPrimaryKeys() {
        return new FilteringIterator(this.primaryKeys()){

            @Override
            protected boolean accept(Object o) {
                return ((MWXmlField)o).isSpecified();
            }
        };
    }

    private void setPrimaryKeysForTopLink(List primaryKeys) {
        this.primaryKeys = primaryKeys;
    }
}

