/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWInterfaceDescriptor
extends MWDescriptor
implements MWRelationalDescriptor {
    private Collection implementorHandles;
    public static final String IMPLEMENTORS_COLLECTION = "implementors";
    private MWHandle.NodeReferenceScrubber implementorScrubber;
    private MWInheritancePolicy nullInheritancePolicy = new MWNullInheritancePolicy(this);

    private MWInterfaceDescriptor() {
    }

    public MWInterfaceDescriptor(MWProject parent, MWClass type, String name) {
        super(parent, type, name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.implementorHandles = new Vector();
    }

    private Iterator implementorHandles() {
        return new CloneIterator(this.implementorHandles){

            @Override
            protected void remove(Object current) {
                MWInterfaceDescriptor.this.removeImplementorHandle((MWDescriptorHandle)current);
            }
        };
    }

    void removeImplementorHandle(MWDescriptorHandle handle) {
        this.implementorHandles.remove(handle);
        this.fireItemRemoved(IMPLEMENTORS_COLLECTION, handle.getDescriptor());
        this.getProject().implementorsChangedFor(this);
    }

    @Override
    public Iterator implementors() {
        return new TransformationIterator(this.implementorHandles()){

            @Override
            protected Object transform(Object next) {
                return ((MWDescriptorHandle)next).getDescriptor();
            }
        };
    }

    public int implementorsSize() {
        return this.implementorHandles.size();
    }

    public void addImplementor(MWDescriptor descriptor) {
        if (CollectionTools.contains(this.implementors(), (Object)descriptor)) {
            throw new IllegalArgumentException(descriptor.toString());
        }
        this.implementorHandles.add(new MWDescriptorHandle(this, descriptor, this.implementorScrubber()));
        this.fireItemAdded(IMPLEMENTORS_COLLECTION, descriptor);
        this.getProject().implementorsChangedFor(this);
    }

    public void removeImplementor(MWDescriptor descriptor) {
        Iterator stream = this.implementors();
        while (stream.hasNext()) {
            if (stream.next() != descriptor) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(descriptor.toString());
    }

    public void removeImplementors(Collection descriptors) {
        this.removeImplementors(descriptors.iterator());
    }

    public void removeImplementors(Iterator descriptors) {
        while (descriptors.hasNext()) {
            this.removeImplementor((MWDescriptor)descriptors.next());
        }
    }

    public void clearImplementors() {
        Iterator stream = this.implementorHandles();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    public SortedSet getAllQueryKeys() {
        HashBag queryKeyNameBag = new HashBag();
        TreeSet<MWQueryKey> commonQueryKeys = new TreeSet<MWQueryKey>();
        MWTableDescriptor descriptor = null;
        Iterator implementors = this.implementors();
        while (implementors.hasNext()) {
            descriptor = (MWTableDescriptor)implementors.next();
            Iterator allQueryKeys = descriptor.getAllQueryKeysIncludingInherited().iterator();
            ArrayList<String> duplicates = new ArrayList<String>();
            while (allQueryKeys.hasNext()) {
                String queryKeyName = ((MWQueryKey)allQueryKeys.next()).getName();
                if (duplicates.contains(queryKeyName)) continue;
                duplicates.add(queryKeyName);
                queryKeyNameBag.add(queryKeyName);
            }
        }
        for (String queryKeyName : queryKeyNameBag) {
            if (queryKeyNameBag.count(queryKeyName) != this.implementorsSize()) continue;
            commonQueryKeys.add(descriptor.queryKeyNamedIncludingInherited(queryKeyName));
        }
        return commonQueryKeys;
    }

    public Iterator allQueryKeyNames(Iterator iterator) {
        return new TransformationIterator(iterator){

            @Override
            protected Object transform(Object next) {
                return ((MWQueryKey)next).getName();
            }
        };
    }

    public boolean hasImplementor(MWDescriptor descriptor) {
        return CollectionTools.contains(this.implementors(), (Object)descriptor);
    }

    public Iterator allAssociatedFields() {
        return NullIterator.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.implementorHandles;
        synchronized (collection) {
            children.addAll(this.implementorHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber implementorScrubber() {
        if (this.implementorScrubber == null) {
            this.implementorScrubber = this.buildImplementorScrubber();
        }
        return this.implementorScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildImplementorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWInterfaceDescriptor.this.removeImplementorHandle((MWDescriptorHandle)handle);
            }

            public String toString() {
                return "MWInterfaceDescriptor.buildImplementorScrubber()";
            }
        };
    }

    @Override
    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        super.descriptorReplaced(oldDescriptor, newDescriptor);
        if (this.hasImplementor(oldDescriptor)) {
            this.removeImplementor(oldDescriptor);
            if (newDescriptor instanceof MWTableDescriptor) {
                this.addImplementor(newDescriptor);
            }
        }
    }

    @Override
    public void initializeOn(MWDescriptor newDescriptor) {
        ((MWRelationalDescriptor)((Object)newDescriptor)).initializeFromMWInterfaceDescriptor(this);
    }

    @Override
    protected void refreshClass(MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        super.refreshClass(refreshPolicy);
        if (!this.getMWClass().isInterface()) {
            this.asMWTableDescriptor();
        }
    }

    @Override
    public void applyAdvancedPolicyDefaults(MWProjectDefaultsPolicy defaultsPolicy) {
    }

    @Override
    public void unmap() {
        super.unmap();
        this.clearImplementors();
    }

    @Override
    public boolean canHaveInheritance() {
        return false;
    }

    @Override
    public MWInheritancePolicy getInheritancePolicy() {
        return this.nullInheritancePolicy;
    }

    @Override
    public boolean hasDefinedInheritance() {
        return false;
    }

    @Override
    public boolean hasActiveInstantiationPolicy() {
        return false;
    }

    @Override
    public Iterator allQueryKeys() {
        return this.getAllQueryKeys().iterator();
    }

    @Override
    public Iterator allQueryKeysIncludingInherited() {
        return this.allQueryKeys();
    }

    @Override
    public Iterator allQueryKeyNames() {
        return new TransformationIterator(this.allQueryKeys()){

            @Override
            protected Object transform(Object next) {
                return ((MWQueryKey)next).getName();
            }
        };
    }

    @Override
    public MWQueryKey queryKeyNamed(String name) {
        Iterator stream = this.allQueryKeys();
        while (stream.hasNext()) {
            MWQueryKey queryKey = (MWQueryKey)stream.next();
            if (!queryKey.getName().equals(name)) continue;
            return queryKey;
        }
        return null;
    }

    @Override
    public MWQueryKey queryKeyNamedIncludingInherited(String name) {
        return this.queryKeyNamed(name);
    }

    @Override
    public Iterator associatedTables() {
        return NullIterator.instance();
    }

    @Override
    public int associatedTablesSize() {
        return 0;
    }

    @Override
    public MWTable getPrimaryTable() {
        return null;
    }

    @Override
    public Iterator associatedTablesIncludingInherited() {
        return this.associatedTables();
    }

    @Override
    public int associatedTablesIncludingInheritedSize() {
        return this.associatedTablesSize();
    }

    @Override
    public Iterator candidateTables() {
        return this.associatedTables();
    }

    @Override
    public int candidateTablesSize() {
        return this.associatedTablesSize();
    }

    @Override
    public Iterator candidateTablesIncludingInherited() {
        return this.candidateTables();
    }

    @Override
    public int candidateTablesIncludingInheritedSize() {
        return this.candidateTablesSize();
    }

    @Override
    public void notifyExpressionsToRecalculateQueryables() {
    }

    @Override
    public List getQueryables(Filter queryableFilter) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isTableDescriptor() {
        return false;
    }

    @Override
    public boolean isAggregateDescriptor() {
        return false;
    }

    @Override
    public Collection buildAggregateFieldNameGenerators() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void initializeFromMWAggregateDescriptor(MWAggregateDescriptor oldDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(oldDescriptor);
    }

    @Override
    public void initializeFromMWRelationalClassDescriptor(MWRelationalClassDescriptor oldDescriptor) {
        this.initializeFromMWMappingDescriptor(oldDescriptor);
    }

    @Override
    public void initializeFromMWTableDescriptor(MWTableDescriptor oldDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(oldDescriptor);
    }

    @Override
    public void initializeFromMWInterfaceDescriptor(MWInterfaceDescriptor oldDescriptor) {
        this.initializeFromMWDescriptor(oldDescriptor);
    }

    @Override
    public MWAggregateDescriptor asMWAggregateDescriptor() {
        throw new RuntimeException("Can't change an interface descriptor to an aggregate descriptor unless the type is not an interface.");
    }

    @Override
    public MWTableDescriptor asMWTableDescriptor() throws InterfaceDescriptorCreationException {
        if (this.getMWClass().isInterface()) {
            throw new RuntimeException("Can't change an interface descriptor to a class descriptor unless the type is not an interface.");
        }
        MWTableDescriptor newDescriptor = (MWTableDescriptor)this.getProject().addDescriptorForType(this.getMWClass());
        this.initializeDescriptorAfterMorphing(newDescriptor);
        return newDescriptor;
    }

    @Override
    public MWInterfaceDescriptor asMWInterfaceDescriptor() {
        return this;
    }

    @Override
    public boolean isInterfaceDescriptor() {
        return true;
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkImplementors(newProblems);
    }

    private void checkImplementors(List newProblems) {
        Iterator stream = this.implementors();
        while (stream.hasNext()) {
            MWDescriptor implementor = (MWDescriptor)stream.next();
            if (CollectionTools.contains(implementor.getMWClass().allInterfaces(), (Object)this.getMWClass())) continue;
            newProblems.add(this.buildProblem("0225", implementor.displayString()));
        }
    }

    @Override
    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor runtimeDescriptor = super.buildRuntimeDescriptor();
        Iterator queryKeys = this.allQueryKeys();
        while (queryKeys.hasNext()) {
            MWQueryKey bldrQueryKey = (MWQueryKey)queryKeys.next();
            QueryKey queryKey = new QueryKey();
            queryKey.setName(bldrQueryKey.getName());
            runtimeDescriptor.addQueryKey(queryKey);
        }
        return runtimeDescriptor;
    }

    @Override
    protected ClassDescriptor buildBasicRuntimeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClassName(this.getMWClass().getName());
        descriptor.descriptorIsForInterface();
        return descriptor;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWInterfaceDescriptor.class);
        descriptor.getInheritancePolicy().setParentClass(MWDescriptor.class);
        XMLCompositeCollectionMapping implementorHandlesMapping = new XMLCompositeCollectionMapping();
        implementorHandlesMapping.setAttributeName("implementorHandles");
        implementorHandlesMapping.setSetMethodName("setImplementorHandlesForTopLink");
        implementorHandlesMapping.setGetMethodName("getImplementorHandlesForTopLink");
        implementorHandlesMapping.setReferenceClass(MWDescriptorHandle.class);
        implementorHandlesMapping.setXPath("implementor-handles/descriptor-handle");
        descriptor.addMapping((DatabaseMapping)implementorHandlesMapping);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getImplementorHandlesForTopLink() {
        Collection collection = this.implementorHandles;
        synchronized (collection) {
            return new TreeSet(this.implementorHandles);
        }
    }

    private void setImplementorHandlesForTopLink(Collection implementorHandles) {
        Iterator stream = implementorHandles.iterator();
        while (stream.hasNext()) {
            ((MWDescriptorHandle)stream.next()).setScrubber(this.implementorScrubber());
        }
        this.implementorHandles = implementorHandles;
    }
}

