/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.XmlProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ImportSchemaDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaDialogUtilities;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.UiSchemaResourceBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaRepositoryPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class XmlSchemaRepositoryNode
extends MappingsApplicationNode
implements ProjectNode.Child {
    private ListValueModel childrenModel;

    public XmlSchemaRepositoryNode(MWXmlSchemaRepository schemaRepository, XmlProjectNode projectNode) {
        this(schemaRepository, projectNode.getApplicationContext(), projectNode.getPlugin(), projectNode);
    }

    private XmlSchemaRepositoryNode(MWXmlSchemaRepository schemaRepository, ApplicationContext context, Plugin plugin, XmlProjectNode projectNode) {
        super((MWModel)schemaRepository, (TreeNodeValueModel)projectNode, plugin, context);
    }

    @Override
    protected ApplicationContext expandContext(ApplicationContext context) {
        return super.expandContext(context).buildExpandedResourceRepositoryContext(UiSchemaResourceBundle.class);
    }

    @Override
    public int getProjectNodeChildPriority() {
        return 1;
    }

    private FrameworkAction getImportSchemaAction(WorkbenchContext context) {
        return new ImportSchemaAction(context);
    }

    private FrameworkAction getReimportAllSchemasAction(WorkbenchContext context) {
        return new ReimportAllSchemasAction(context);
    }

    @Override
    public ListValueModel getChildrenModel() {
        if (this.childrenModel == null) {
            this.childrenModel = this.buildChildrenModel();
        }
        return this.childrenModel;
    }

    protected ListValueModel buildChildrenModel() {
        SortedListValueModelAdapter childrenModel = new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
        childrenModel.addListChangeListener("value", this.buildChildrenModelListener());
        return childrenModel;
    }

    private ListChangeListener buildChildrenModelListener() {
        return new ListChangeAdapter(){

            public void itemsRemoved(ListChangeEvent e) {
                ListIterator stream = e.items();
                while (stream.hasNext()) {
                    ((XmlSchemaNode)stream.next()).disposePropertiesPages();
                }
            }
        };
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildNodeWrapperAdapter(), "displayString");
    }

    protected ListValueModel buildNodeWrapperAdapter() {
        return new TransformationListValueModelAdapter(this.buildNodeChildrenAdapter()){

            @Override
            protected Object transformItem(Object item) {
                return new XmlSchemaNode((MWXmlSchema)item, XmlSchemaRepositoryNode.this);
            }
        };
    }

    protected CollectionValueModel buildNodeChildrenAdapter() {
        return new CollectionAspectAdapter(this, "schemas"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWXmlSchemaRepository)this.subject).schemas();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWXmlSchemaRepository)this.subject).schemasSize();
            }
        };
    }

    @Override
    public String helpTopicID() {
        return "xmlSchemaRepository";
    }

    @Override
    protected String buildDisplayString() {
        return this.resourceRepository().getString("SCHEMA_REPOSITORY_NODE_DISPLAY_STRING");
    }

    @Override
    protected String buildIconKey() {
        return "file.xml.multi";
    }

    @Override
    protected Class propertiesPageClass() {
        return XmlSchemaRepositoryPanel.class;
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext localContext = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription desc = new RootMenuDescription();
        MenuGroupDescription group = new MenuGroupDescription();
        group.add(this.getImportSchemaAction(localContext));
        group.add(this.getReimportAllSchemasAction(localContext));
        desc.add(group);
        desc.add(this.buildOracleHelpMenuGroup(localContext));
        return desc;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext localContext = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription desc = new ToolBarDescription();
        ToolBarButtonGroupDescription group = new ToolBarButtonGroupDescription();
        group.add(this.getImportSchemaAction(localContext));
        group.add(this.getReimportAllSchemasAction(localContext));
        desc.add(group);
        return desc;
    }

    MWXmlSchemaRepository getSchemaRepository() {
        return (MWXmlSchemaRepository)this.getValue();
    }

    private final class ReimportAllSchemasAction
    extends AbstractFrameworkAction {
        private ReimportAllSchemasAction(WorkbenchContext context) {
            super(context);
        }

        @Override
        protected void initialize() {
            this.initializeTextAndMnemonic("REIMPORT_ALL_SCHEMAS_ACTION");
            this.initializeToolTipText("REIMPORT_ALL_SCHEMAS_ACTION");
            this.initializeIcon("file.xml.multi.refresh");
            this.setEnabled(true);
        }

        @Override
        protected void execute(ApplicationNode selectedNode) {
            Iterator schemasIterator = ((XmlSchemaRepositoryNode)selectedNode).getSchemaRepository().schemas();
            if (schemasIterator.hasNext()) {
                SchemaDialogUtilities.reloadSchemas(this.getWorkbenchContext(), schemasIterator);
            }
        }
    }

    private final class ImportSchemaAction
    extends AbstractFrameworkAction {
        private ImportSchemaAction(WorkbenchContext context) {
            super(context);
        }

        @Override
        protected void initialize() {
            this.initializeTextAndMnemonic("IMPORT_SCHEMA_ACTION");
            this.initializeToolTipText("IMPORT_SCHEMA_ACTION.TOOL_TIP");
            this.initializeIcon("file.xml.new");
            this.setEnabled(true);
        }

        @Override
        protected void execute(ApplicationNode selectedNode) {
            MWXmlSchema schema = new ImportSchemaDialog(this.getWorkbenchContext(), ((XmlSchemaRepositoryNode)selectedNode).getSchemaRepository()).promptToImportSchema();
            if (schema != null) {
                this.navigatorSelectionModel().setSelectedNode(selectedNode.descendantNodeForValue((Node)schema));
            }
        }
    }
}

