/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

class MultiMethodReflectiveChangeListener
extends ReflectiveChangeListener
implements CollectionChangeListener,
ListChangeListener,
TreeChangeListener {
    private Method addMethod;
    private Method removeMethod;
    private Method replaceMethod;
    private Method changeMethod;

    MultiMethodReflectiveChangeListener(Object target, Method addMethod, Method removeMethod, Method replaceMethod, Method changeMethod) {
        super(target);
        this.addMethod = addMethod;
        this.removeMethod = removeMethod;
        this.replaceMethod = replaceMethod;
        this.changeMethod = changeMethod;
    }

    MultiMethodReflectiveChangeListener(Object target, Method addMethod, Method removeMethod, Method changeMethod) {
        this(target, addMethod, removeMethod, null, changeMethod);
    }

    private void invoke(Method method, CollectionChangeEvent e) {
        if (method.getParameterTypes().length == 0) {
            ClassTools.invokeMethod(method, this.target, EMPTY_COLLECTION_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(method, this.target, new CollectionChangeEvent[]{e});
        }
    }

    @Override
    public void itemsAdded(CollectionChangeEvent e) {
        this.invoke(this.addMethod, e);
    }

    @Override
    public void itemsRemoved(CollectionChangeEvent e) {
        this.invoke(this.removeMethod, e);
    }

    @Override
    public void collectionChanged(CollectionChangeEvent e) {
        this.invoke(this.changeMethod, e);
    }

    private void invoke(Method method, ListChangeEvent e) {
        if (method.getParameterTypes().length == 0) {
            ClassTools.invokeMethod(method, this.target, EMPTY_LIST_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(method, this.target, new ListChangeEvent[]{e});
        }
    }

    @Override
    public void itemsAdded(ListChangeEvent e) {
        this.invoke(this.addMethod, e);
    }

    @Override
    public void itemsRemoved(ListChangeEvent e) {
        this.invoke(this.removeMethod, e);
    }

    @Override
    public void itemsReplaced(ListChangeEvent e) {
        this.invoke(this.replaceMethod, e);
    }

    @Override
    public void listChanged(ListChangeEvent e) {
        this.invoke(this.changeMethod, e);
    }

    private void invoke(Method method, TreeChangeEvent e) {
        if (method.getParameterTypes().length == 0) {
            ClassTools.invokeMethod(method, this.target, EMPTY_TREE_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(method, this.target, new TreeChangeEvent[]{e});
        }
    }

    @Override
    public void nodeAdded(TreeChangeEvent e) {
        this.invoke(this.addMethod, e);
    }

    @Override
    public void nodeRemoved(TreeChangeEvent e) {
        this.invoke(this.removeMethod, e);
    }

    @Override
    public void treeChanged(TreeChangeEvent e) {
        this.invoke(this.changeMethod, e);
    }
}

