/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalColumn
implements ExternalColumn {
    private final String name;
    private final String typeName;
    private final int jdbcTypeCode;
    private final int size;
    private final int scale;
    private final boolean nullable;
    private boolean primaryKey;

    JDBCExternalColumn(ResultSet resultSet) throws SQLException {
        this.name = resultSet.getString(4).trim();
        if (this.name.length() == 0) {
            throw new IllegalStateException("empty column name");
        }
        this.typeName = this.typeNameFrom(resultSet);
        this.jdbcTypeCode = this.jdbcTypeCodeFrom(resultSet);
        this.size = this.sizeFrom(resultSet);
        this.scale = this.scaleFrom(resultSet);
        this.nullable = this.nullableFrom(resultSet);
    }

    private String typeNameFrom(ResultSet resultSet) {
        try {
            return this.trim(resultSet.getString(6));
        }
        catch (SQLException ex) {
            return null;
        }
    }

    private int jdbcTypeCodeFrom(ResultSet resultSet) {
        try {
            return resultSet.getInt(5);
        }
        catch (SQLException ex) {
            return 0;
        }
    }

    private int sizeFrom(ResultSet resultSet) {
        try {
            return resultSet.getInt(7);
        }
        catch (SQLException ex) {
            return 0;
        }
    }

    private int scaleFrom(ResultSet resultSet) {
        try {
            return resultSet.getInt(9);
        }
        catch (SQLException ex) {
            return 0;
        }
    }

    private boolean nullableFrom(ResultSet resultSet) {
        String jdbc_IS_NULLABLE = null;
        try {
            jdbc_IS_NULLABLE = resultSet.getString(18);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return jdbc_IS_NULLABLE == null || !jdbc_IS_NULLABLE.trim().toUpperCase().equals("NO");
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int getJDBCTypeCode() {
        return this.jdbcTypeCode;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.name);
    }

    void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }
}

