/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.XercesTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitSimpleTypeDefinition
extends ExplicitSchemaTypeDefinition
implements MWSimpleTypeDefinition {
    private volatile String variety;
    private volatile ReferencedSimpleTypeDefinition baseType;
    private volatile MWSimpleTypeDefinition itemType;
    private volatile List<MWSimpleTypeDefinition> memberTypes;

    protected ExplicitSimpleTypeDefinition() {
    }

    ExplicitSimpleTypeDefinition(MWModel parent, String name) {
        super(parent, name);
    }

    ExplicitSimpleTypeDefinition(MWModel parent, String name, String namespace) {
        super(parent, name, namespace);
    }

    ExplicitSimpleTypeDefinition(MWModel parent, String name, String namespace, boolean builtIn) {
        super(parent, name, namespace, builtIn);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.variety = "atomic";
        this.baseType = ReferencedSimpleTypeDefinition.simpleUrType(this);
        this.memberTypes = new Vector<MWSimpleTypeDefinition>();
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.baseType);
        if (this.itemType != null) {
            children.add(this.itemType);
        }
        children.addAll(this.memberTypes);
    }

    @Override
    public String getVariety() {
        return this.variety;
    }

    public boolean isAtomic() {
        return this.variety == "atomic";
    }

    public boolean isList() {
        return this.variety == "list";
    }

    public boolean isUnion() {
        return this.variety == "union";
    }

    @Override
    public MWSimpleTypeDefinition getItemType() {
        return this.itemType;
    }

    @Override
    public ListIterator memberTypes() {
        return this.memberTypes.listIterator();
    }

    @Override
    public MWSchemaTypeDefinition getBaseType() {
        return this.baseType;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public Iterator baseBuiltInTypes() {
        if (this.builtIn) {
            return new SingleElementIterator(this);
        }
        if (this.isList()) {
            return this.itemType.baseBuiltInTypes();
        }
        if (this.isUnion()) {
            return new CompositeIterator(this.memberTypeBaseBuiltInTypes());
        }
        return this.baseType.baseBuiltInTypes();
    }

    private Iterator memberTypeBaseBuiltInTypes() {
        return new TransformationIterator(this.memberTypes.iterator()){

            @Override
            protected Object transform(Object next) {
                return ((MWSimpleTypeDefinition)next).baseBuiltInTypes();
            }
        };
    }

    @Override
    public boolean containsText() {
        return true;
    }

    @Override
    public boolean containsWildcard() {
        return false;
    }

    @Override
    public int compareSchemaOrder(MWElementDeclaration element1, MWElementDeclaration element2) {
        return 0;
    }

    @Override
    public String componentTypeName() {
        return "simpleType";
    }

    @Override
    public Iterator structuralComponents() {
        return NullIterator.instance();
    }

    @Override
    protected void reloadInternal(XSObject xsObject) {
        super.reloadInternal(xsObject);
        XSSimpleTypeDecl simpleTypeNode = (XSSimpleTypeDecl)xsObject;
        this.reloadVariety(simpleTypeNode);
        if (this.getNamespaceUrl() != null) {
            this.builtIn = this.getNamespaceUrl().equals("http://www.w3.org/2001/XMLSchema") || this.getNamespaceUrl().equals("http://www.w3.org/2003/11/xpath-datatypes");
        }
    }

    private void reloadVariety(XSSimpleTypeDecl xsSimpleTypeDecl) {
        if (xsSimpleTypeDecl.getVariety() == 2) {
            this.variety = "list";
        } else if (xsSimpleTypeDecl.getVariety() == 3) {
            this.variety = "union";
        } else if (xsSimpleTypeDecl.getVariety() == 1) {
            this.variety = "atomic";
        } else if (xsSimpleTypeDecl.getVariety() == 0) {
            this.variety = "absent";
        } else {
            throw new IllegalArgumentException();
        }
        this.reloadBaseType(xsSimpleTypeDecl);
        this.reloadItemType(xsSimpleTypeDecl);
        this.reloadMemberTypes(xsSimpleTypeDecl);
    }

    private void reloadBaseType(XSSimpleTypeDecl xsSimpleTypeDecl) {
        XSTypeDefinition baseTypeNode = xsSimpleTypeDecl.getBaseType();
        if (baseTypeNode != null) {
            if (this.baseType == null) {
                this.baseType = new ReferencedSimpleTypeDefinition(this, baseTypeNode.getName(), baseTypeNode.getNamespace());
            }
            this.baseType.reload((XSObject)baseTypeNode);
        } else {
            this.baseType = ReferencedSimpleTypeDefinition.simpleUrType(this);
        }
    }

    private void reloadItemType(XSSimpleTypeDecl xsSimpleTypeDecl) {
        MWSimpleTypeDefinition oldItemType = this.itemType;
        XSSimpleTypeDefinition itemTypeNode = xsSimpleTypeDecl.getItemType();
        this.itemType = this.isList() ? MWSimpleTypeDefinition.Reloader.reloadedSimpleType(this, oldItemType, itemTypeNode) : null;
        if (oldItemType != null && oldItemType != this.itemType) {
            this.getProject().nodeRemoved(oldItemType);
        }
    }

    private void reloadMemberTypes(XSSimpleTypeDecl xsSimpleTypeDecl) {
        if (this.isUnion()) {
            MWSimpleTypeDefinition oldMemberType;
            ListIterator<MWSimpleTypeDefinition> memberTypes = this.memberTypes.listIterator();
            ListIterator<XSObject> memberTypeNodes = XercesTools.listIteratorFromXSObjectList(xsSimpleTypeDecl.getMemberTypes());
            while (memberTypes.hasNext() && memberTypeNodes.hasNext()) {
                XSSimpleTypeDefinition memberTypeNode;
                MWSimpleTypeDefinition newMemberType;
                oldMemberType = memberTypes.next();
                if (oldMemberType == (newMemberType = MWSimpleTypeDefinition.Reloader.reloadedSimpleType(this, oldMemberType, memberTypeNode = (XSSimpleTypeDefinition)memberTypeNodes.next()))) continue;
                memberTypes.set(newMemberType);
                this.getProject().nodeRemoved(oldMemberType);
            }
            while (memberTypeNodes.hasNext()) {
                XSSimpleTypeDefinition memberTypeNode = (XSSimpleTypeDefinition)memberTypeNodes.next();
                MWSimpleTypeDefinition newMemberType = MWSimpleTypeDefinition.Reloader.reloadedSimpleType(this, null, memberTypeNode);
                memberTypes.add(newMemberType);
            }
            while (memberTypes.hasNext()) {
                oldMemberType = memberTypes.next();
                memberTypes.remove();
                this.getProject().nodeRemoved(oldMemberType);
            }
        } else {
            Iterator<MWSimpleTypeDefinition> stream = this.memberTypes.iterator();
            while (stream.hasNext()) {
                MWSimpleTypeDefinition oldMemberType = stream.next();
                stream.remove();
                this.getProject().nodeRemoved(oldMemberType);
            }
        }
    }

    @Override
    public void resolveReferences() {
        super.resolveReferences();
        this.baseType.resolveReferences();
        if (this.itemType != null) {
            this.itemType.resolveReferences();
        }
        Iterator<MWSimpleTypeDefinition> stream = this.memberTypes.iterator();
        while (stream.hasNext()) {
            stream.next().resolveReferences();
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ExplicitSimpleTypeDefinition.class);
        descriptor.getInheritancePolicy().setParentClass(ExplicitSchemaTypeDefinition.class);
        XMLDirectMapping varietyMapping = (XMLDirectMapping)descriptor.addDirectMapping("variety", "variety/text()");
        ObjectTypeConverter varietyConverter = new ObjectTypeConverter();
        varietyConverter.addConversionValue(null, (Object)"atomic");
        varietyConverter.addConversionValue((Object)"atomic", (Object)"atomic");
        varietyConverter.addConversionValue((Object)"list", (Object)"list");
        varietyConverter.addConversionValue((Object)"union", (Object)"union");
        varietyMapping.setConverter((Converter)varietyConverter);
        XMLCompositeObjectMapping baseTypeMapping = new XMLCompositeObjectMapping();
        baseTypeMapping.setAttributeName("baseType");
        baseTypeMapping.setReferenceClass(ReferencedSimpleTypeDefinition.class);
        baseTypeMapping.setXPath("base-type");
        descriptor.addMapping((DatabaseMapping)baseTypeMapping);
        XMLCompositeObjectMapping itemTypeMapping = new XMLCompositeObjectMapping();
        itemTypeMapping.setAttributeName("itemType");
        itemTypeMapping.setReferenceClass(ReferencedSimpleTypeDefinition.class);
        itemTypeMapping.setXPath("item-type");
        descriptor.addMapping((DatabaseMapping)itemTypeMapping);
        XMLCompositeCollectionMapping memberTypesMapping = new XMLCompositeCollectionMapping();
        memberTypesMapping.setAttributeName("memberTypes");
        memberTypesMapping.setReferenceClass(ReferencedSimpleTypeDefinition.class);
        memberTypesMapping.setXPath("member-types");
        descriptor.addMapping((DatabaseMapping)memberTypesMapping);
        return descriptor;
    }
}

