/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNameDialog;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

class RenameTableAction
extends AbstractFrameworkAction {
    RenameTableAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeIcon("rename");
        this.initializeTextAndMnemonic("RENAME");
        this.initializeToolTipText("RENAME");
    }

    @Override
    protected void execute(ApplicationNode selectedNode) {
        this.promptToRenameTable((MWTable)selectedNode.getValue());
        this.navigatorSelectionModel().setSelectedNode(selectedNode);
    }

    private void promptToRenameTable(MWTable table) {
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        String shortName = table.getShortName();
        while (true) {
            TableNameDialog tableNameDialog = new TableNameDialog(this.getWorkbenchContext(), this.resourceRepository().getString("RENAME_TABLE_DIALOG.title", table.getName()), this.resourceRepository().getString("RENAME_TABLE_DIALOG.message"), catalog, schema, shortName);
            tableNameDialog.show();
            if (tableNameDialog.wasCanceled()) {
                return;
            }
            catalog = tableNameDialog.catalog();
            schema = tableNameDialog.schema();
            shortName = tableNameDialog.shortName();
            try {
                table.rename(catalog, schema, shortName);
                return;
            }
            catch (IllegalArgumentException ex) {
                int input;
                String duplicateName = NameTools.buildQualifiedDatabaseObjectName((String)catalog, (String)schema, (String)shortName);
                if ((input = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_MESSAGE", duplicateName), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_TITLE"), 2, 3)) != 2) continue;
                return;
            }
            break;
        }
    }
}

