/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;

public class SelectionCriteriaInOneToManyTest
extends AutoVerifyTestCase {
    private Employee employee1;
    private Employee employee2;
    private Employee employee3;
    private DatabaseSession newSession;
    protected Project project;

    public SelectionCriteriaInOneToManyTest() {
        this.setDescription("Verify that buildSelectionCriteria in one-to-many mapping works");
    }

    protected void setup() throws Exception {
        MappingSystem mappingSystem = new MappingSystem();
        this.project = mappingSystem.project;
        ClassDescriptor descriptor = (ClassDescriptor)this.project.getDescriptors().get(Employee.class);
        descriptor.setAmendmentClass(MappingSystem.class);
        descriptor.setAmendmentMethodName("modifyOneToManyMappingDescriptor");
        descriptor.applyAmendmentMethod();
        DatabaseLogin databaseLogin = (DatabaseLogin)this.getSession().getLogin().clone();
        this.project.setLogin(databaseLogin);
        this.newSession = this.project.createDatabaseSession();
        this.newSession.setSessionLog(this.getSession().getSessionLog());
        this.newSession.login();
    }

    public void test() {
        this.modifyOneToManyMappingExample();
    }

    protected void verify() {
        if (!this.employee1.getManagedEmployees().contains(this.employee3)) {
            throw new TestErrorException("OneToManyMapping.buildSelectionCriteria could not set the correct selection criteria.1");
        }
        if (this.employee2.getManagedEmployees().contains(this.employee3)) {
            throw new TestErrorException("OneToManyMapping.buildSelectionCriteria could not set the correct selection criteria.2");
        }
    }

    public void reset() {
        this.newSession.getIdentityMapAccessor().initializeIdentityMaps();
        this.newSession.logout();
    }

    public void modifyOneToManyMappingExample() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").equal((Object)"Dave").and(builder.get("lastName").equal((Object)"Vadis"));
        this.employee1 = (Employee)this.newSession.readObject(Employee.class, exp);
        ExpressionBuilder builder2 = new ExpressionBuilder();
        Expression exp2 = builder2.get("firstName").equal((Object)"Tracy").and(builder2.get("lastName").equal((Object)"Rue"));
        this.employee2 = (Employee)this.newSession.readObject(Employee.class, exp2);
        ExpressionBuilder builder3 = new ExpressionBuilder();
        Expression exp3 = builder3.get("firstName").equal((Object)"Tracy").and(builder3.get("lastName").equal((Object)"Chapman"));
        this.employee3 = (Employee)this.newSession.readObject(Employee.class, exp3);
    }
}

