/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jaxrs;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Address;
import org.eclipse.persistence.testing.models.jpa.jaxrs.JAXRSPopulator;
import org.eclipse.persistence.testing.models.jpa.jaxrs.JAXRSTableCreator;

public class ContextResolverTestCases
extends JUnitTestCase {
    private JAXBContext jc;
    protected DatabaseSession session;

    public ContextResolverTestCases(String name) throws Exception {
        super(name);
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("eclipselink-oxm-xml", "META-INF/binding-address.xml");
        this.jc = JAXBContext.newInstance((Class[])new Class[]{Address.class}, props);
    }

    public JAXRSPopulator setup() {
        this.session = JUnitTestCase.getServerSession();
        JAXRSTableCreator tableCreator = new JAXRSTableCreator();
        tableCreator.dropTableConstraints((Session)this.session);
        tableCreator.replaceTables(this.session);
        JAXRSPopulator jaxrsPopulator = new JAXRSPopulator();
        return jaxrsPopulator;
    }

    protected Address getControlObject2() {
        Address address = new Address();
        address.setId(2L);
        address.setStreet("1111 Moose Rd.");
        address.setCity("Calgary");
        return address;
    }

    protected Address getControlObject11() {
        Address address = new Address();
        address.setId(11L);
        address.setStreet("11 Nowhere Drive");
        address.setCity("Orleans");
        return address;
    }

    protected String getID() {
        return "2";
    }

    protected JAXBContext getJAXBContext() {
        return this.jc;
    }

    protected String getURL() {
        return "http://%%host:port%%/CustomerWAR/rest/address_war";
    }

    public void testGetAddress() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer2();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL() + "/" + "2");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Address testObject = (Address)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        int response = connection.getResponseCode();
        connection.disconnect();
        ContextResolverTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        ContextResolverTestCases.assertEquals((Object)this.getControlObject2(), (Object)testObject);
    }

    public void testGetAddressJSON() throws Exception {
        JAXRSPopulator jaxrsPopulator = this.setup();
        jaxrsPopulator.buildExamplesCustomer11();
        jaxrsPopulator.persistExample((Session)this.session);
        URL url = new URL(this.getURL() + "/" + "11");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        Address testObject = (Address)u.unmarshal((Source)json, Address.class).getValue();
        int response = connection.getResponseCode();
        connection.disconnect();
        ContextResolverTestCases.assertTrue((response < 300 && response >= 200 ? 1 : 0) != 0);
        ContextResolverTestCases.assertEquals((Object)this.getControlObject11(), (Object)testObject);
    }
}

