/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.LocalSchemaComponentNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCurator;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

abstract class SchemaComponentNode
extends AbstractTreeNodeValueModel
implements Displayable {
    private AbstractTreeNodeValueModel parent;
    protected MWSchemaComponent component;
    private ListValueModel childrenModel;
    protected SchemaComponentNodeStructure structure;

    SchemaComponentNode(AbstractTreeNodeValueModel parent, MWSchemaComponent component) {
        this.parent = parent;
        this.initialize(component);
    }

    protected void initialize(MWSchemaComponent component) {
        this.component = component;
        this.childrenModel = this.buildChildrenModel();
        this.structure = this.buildStructure(component);
    }

    protected ListValueModel buildChildrenModel() {
        return new TransformationListValueModelAdapter(this.buildStructuralComponentsAdapter()){

            @Override
            protected Object transformItem(Object item) {
                return SchemaComponentNode.this.buildLocalComponentNode((MWSchemaComponent)item);
            }
        };
    }

    protected ListValueModel buildStructuralComponentsAdapter() {
        return new ListCurator((Model)this.component){

            @Override
            public Iterator getValueForRecord() {
                return ((MWSchemaComponent)this.subject).structuralComponents();
            }
        };
    }

    protected SchemaComponentNode buildLocalComponentNode(MWSchemaComponent component) {
        return new LocalSchemaComponentNode(this, component);
    }

    protected abstract SchemaComponentNodeStructure buildStructure(MWSchemaComponent var1);

    protected PropertyChangeListener buildDisplayStringChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SchemaComponentNode.this.fireStateChanged();
            }
        };
    }

    protected ListIterator details() {
        return this.structure.details();
    }

    @Override
    public TreeNodeValueModel getParent() {
        return this.parent;
    }

    @Override
    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    @Override
    protected void engageValue() {
    }

    @Override
    protected void disengageValue() {
        this.structure.disengageComponent();
    }

    @Override
    public Object getValue() {
        return this.component;
    }

    @Override
    public String displayString() {
        return this.structure.displayString();
    }

    @Override
    public Icon icon() {
        return null;
    }

    public int compareTo(Object o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }
}

