/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.event.MouseEvent;
import java.util.ListIterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.OrderingAttributeDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.BidiTransformer;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

class OrderingAttributesPanel
extends AbstractAttributeItemsPanel {
    private Filter traversableFilter;
    private Filter chooseableFilter;

    public OrderingAttributesPanel(PropertyValueModel queryHolder, Filter traversableFilter, Filter chooseableFilter, WorkbenchContextHolder contextHolder) {
        super(queryHolder, contextHolder);
        this.traversableFilter = traversableFilter;
        this.chooseableFilter = chooseableFilter;
    }

    @Override
    protected PropertyValueModel buildQueryHolder(PropertyValueModel queryHolder) {
        return new FilteringPropertyValueModel(queryHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWOrderableQuery;
            }
        };
    }

    @Override
    protected String helpTopicId() {
        return "query.orderingAttributes";
    }

    @Override
    String listTitleKey() {
        return "ORDERING_ATTRIBUTES_LIST";
    }

    @Override
    protected AddRemovePanel buildAddRemovePanel() {
        final AddRemoveTablePanel tablePanel = new AddRemoveTablePanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAttributesPanelAdapter(), this.buildAttributesHolder(), (ColumnAdapter)new OrderingAttributesColumnAdapter(this.resourceRepository()), 3);
        tablePanel.setBorder(this.buildTitledBorder(this.listTitleKey()));
        SwingComponentFactory.addDoubleClickMouseListener(tablePanel.getComponent(), new DoubleClickMouseListener(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                OrderingAttributesPanel.this.editSelectedAttribute((MWAttributeItem)tablePanel.getSelectionModel().getSelectedValue());
            }
        });
        this.addHelpTopicId(tablePanel, this.helpTopicId());
        this.updateTableColumns((JTable)tablePanel.getComponent());
        return tablePanel;
    }

    @Override
    protected boolean panelEnabled(MWQueryFormat queryFormat) {
        return queryFormat.orderingAttributesAllowed();
    }

    private void updateTableColumns(JTable table) {
        int rowHeight = 0;
        TableColumn column = table.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer functionRenderer = this.buildOrderingComboBoxRenderer();
        column.setCellRenderer(functionRenderer);
        column.setCellEditor(new TableCellEditorAdapter(this.buildOrderingComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, functionRenderer.getPreferredHeight());
        column = table.getColumnModel().getColumn(0);
        column.setCellRenderer(new SimpleTableCellRenderer(){

            @Override
            protected String buildText(Object value) {
                if (value != null) {
                    return ((MWQueryableArgument)value).displayString();
                }
                return "";
            }
        });
        table.setRowHeight(rowHeight);
    }

    private ComboBoxModel buildOrderingComboBoxModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{this.resourceRepository().getString("ASCENDING_CHOICE"), this.resourceRepository().getString("DESCENDING_CHOICE")});
    }

    private ComboBoxTableCellRenderer buildOrderingComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildOrderingComboBoxModel());
    }

    @Override
    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            @Override
            public String optionalButtonKey() {
                return "ORDERING_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                OrderingAttributesPanel.this.editSelectedAttribute((MWAttributeItem)listSelectionModel.getSelectedValue());
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                OrderingAttributesPanel.this.addOrderingItem();
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] selectedValues = listSelectionModel.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    ((MWOrderableQuery)OrderingAttributesPanel.this.getQuery()).removeOrderingItem((Ordering)selectedValues[i]);
                }
            }

            @Override
            public void moveItemsDown(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWOrderableQuery)OrderingAttributesPanel.this.getQuery()).moveOrderingItemDown((Ordering)items[i]);
                }
            }

            @Override
            public void moveItemsUp(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWOrderableQuery)OrderingAttributesPanel.this.getQuery()).moveOrderingItemUp((Ordering)items[i]);
                }
            }
        };
    }

    @Override
    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "orderingItems"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWOrderableQuery)this.subject).orderingItems();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWOrderableQuery)this.subject).orderingItemsSize();
            }
        };
    }

    private void addOrderingItem() {
        this.editSelectedAttribute(null);
    }

    @Override
    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem item) {
        return new OrderingAttributeDialog((MWOrderableQuery)this.getQuery(), (Ordering)item, this.traversableFilter, this.chooseableFilter, this.getWorkbenchContext());
    }

    protected Filter getTraversableFilter() {
        return this.traversableFilter;
    }

    protected Filter getChooseableFilter() {
        return this.chooseableFilter;
    }

    private static class OrderingAttributesColumnAdapter
    implements ColumnAdapter {
        ResourceRepository resourceRepository;
        public static final int ATTRIBUTE_COLUMN = 0;
        public static final int ORDER_COLUMN = 1;
        public static final int COLUMN_COUNT = 2;
        private final String[] COLUMN_NAME_KEYS = new String[]{"ATTRIBUTE_COLUMN_HEADER", "ORDER_COLUMN_HEADER"};
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        private OrderingAttributesColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        private PropertyValueModel buildAttributeAdapter(MWAttributeItem item) {
            return new PropertyAspectAdapter(EMPTY_STRING_ARRAY, (Model)item){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWAttributeItem)this.subject).getQueryableArgument();
                }
            };
        }

        private PropertyValueModel buildOrderAdapter(Ordering item) {
            return new TransformationPropertyValueModel(new PropertyAspectAdapter("ascending", (Model)item){

                @Override
                protected Object getValueFromSubject() {
                    return ((Ordering)this.subject).isAscending();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((Ordering)this.subject).setAscending(((Boolean)value).booleanValue());
                }
            }, new BidiTransformer(){

                public Object reverseTransform(Object o) {
                    if (o != null && ((String)o).equals(OrderingAttributesColumnAdapter.this.resourceRepository.getString("ASCENDING_BUTTON"))) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }

                public Object transform(Object o) {
                    if (((Boolean)o).equals(Boolean.TRUE)) {
                        return OrderingAttributesColumnAdapter.this.resourceRepository.getString("ASCENDING_BUTTON");
                    }
                    return OrderingAttributesColumnAdapter.this.resourceRepository.getString("DESCENDING_BUTTON");
                }
            });
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            Ordering attributeItem = (Ordering)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildAttributeAdapter((MWAttributeItem)attributeItem), this.buildOrderAdapter(attributeItem)};
            return result;
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[index]);
        }

        @Override
        public boolean isColumnEditable(int index) {
            return index == 1;
        }
    }
}

