/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWTransactionalProjectCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectCacheExpiryPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class ProjectCachingPolicyPanel
extends AbstractSubjectPanel {
    ProjectCachingPolicyPanel(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)subjectHolder, contextHolder);
    }

    private ComboBoxModel buildCacheCoordinationComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildCacheCoordinationListHolder(), this.buildCacheCoordinationSelectionHolder());
    }

    private void buildCacheCoordinationComponentEnabler(JComboBox comboBox) {
        new ComponentEnabler((ValueModel)this.buildCacheCoordinationEnablerHolder(), comboBox);
    }

    private PropertyValueModel buildCacheCoordinationEnablerHolder() {
        return new TransformationPropertyValueModel(this.buildCacheIsolationSelectionHolder()){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return ((MWCachingPolicy.CacheIsolationOption)value).getMWModelOption() == "Shared";
            }
        };
    }

    private ListValueModel buildCacheCoordinationListHolder() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWTransactionalProjectCachingPolicy.cacheCoordinationOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildCacheCoordinationSelectionHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "cacheCoordination"){

            @Override
            protected Object getValueFromSubject() {
                MWCachingPolicy policy = (MWCachingPolicy)this.subject;
                return policy.getCacheCoordination();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWCachingPolicy policy = (MWCachingPolicy)this.subject;
                policy.setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)value);
            }
        };
    }

    private ComboBoxModel buildCacheIsolationComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildCacheIsolationListHolder(), this.buildCacheIsolationSelectionHolder());
    }

    private ListValueModel buildCacheIsolationListHolder() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWTransactionalProjectCachingPolicy.cacheIsolationOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildCacheIsolationSelectionHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "cacheIsolation"){

            @Override
            protected Object getValueFromSubject() {
                MWCachingPolicy policy = (MWCachingPolicy)this.subject;
                return policy.getCacheIsolation();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWCachingPolicy policy = (MWCachingPolicy)this.subject;
                policy.setCacheIsolation((MWCachingPolicy.CacheIsolationOption)value);
            }
        };
    }

    private PropertyValueModel buildCacheSizeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "cacheSize"){

            @Override
            protected Object getValueFromSubject() {
                return new Integer(((MWCachingPolicy)this.subject).getCacheSize());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setCacheSize(((Number)value).intValue());
            }
        };
    }

    private NumberSpinnerModelAdapter buildCacheSizeSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildCacheSizeHolder(), new Integer(0), new Integer(99999), new Integer(1), new Integer(100));
    }

    private ComboBoxModel buildCacheTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildCacheTypeListHolder(), this.buildCacheTypeSelectionHolder());
    }

    private ListValueModel buildCacheTypeListHolder() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWTransactionalProjectCachingPolicy.cacheTypeOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildCacheTypeSelectionHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "cacheType"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setCacheType((MWCachingPolicy.CacheTypeOption)value);
            }
        };
    }

    private ComboBoxModel buildExistenceCheckingComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildExistenceCheckingListHolder(), this.buildExistenceCheckingSelectionHolder());
    }

    private ListValueModel buildExistenceCheckingListHolder() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWTransactionalProjectCachingPolicy.existenceCheckingOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildExistenceCheckingSelectionHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "existenceChecking"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getExistenceChecking();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setExistenceChecking((MWCachingPolicy.ExistenceCheckingOption)value);
            }
        };
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        Insets offset = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        offset.left += 5;
        offset.right += 5;
        JComponent cacheType = this.buildLabeledComboBox("CACHING_POLICY_CACHE_TYPE_CHOOSER", this.buildCacheTypeComboBoxModel(), this.buildToplinkOptionRenderer());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, offset.left, 0, offset.right);
        this.add((Component)cacheType, constraints);
        this.helpManager().addTopicID(cacheType, "project.defaults.cacheType");
        JComponent cachingSiseWidgets = this.buildLabeledSpinnerNumber("CACHING_POLICY_CACHE_SIZE_SPINNER", this.buildCacheSizeSpinnerModel());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, offset.left, 0, offset.right);
        this.add((Component)cachingSiseWidgets, constraints);
        this.helpManager().addTopicID(cachingSiseWidgets, "project.defaults.cacheSize");
        JComponent cacheIsolationWidgets = this.buildLabeledComboBox("CACHING_POLICY_CACHE_ISOLATION_CHOOSER", this.buildCacheIsolationComboBoxModel(), this.buildToplinkOptionRenderer());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, offset.left, 0, offset.right);
        this.add((Component)cacheIsolationWidgets, constraints);
        this.helpManager().addTopicID(cacheIsolationWidgets, "project.defaults.cacheIsolation");
        JComboBox cacheCoodinationComboBox = new JComboBox(this.buildCacheCoordinationComboBoxModel());
        cacheCoodinationComboBox.setRenderer(this.buildToplinkOptionRenderer());
        JComponent cacheCoordinationWidgets = this.buildLabeledComponent("CACHING_POLICY_CACHE_COORDINATION_CHOOSER", cacheCoodinationComboBox);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, offset.left, 0, offset.right);
        this.add((Component)cacheCoordinationWidgets, constraints);
        this.buildCacheCoordinationComponentEnabler(cacheCoodinationComboBox);
        this.helpManager().addTopicID(cacheCoordinationWidgets, "project.defaults.cacheCoord");
        ProjectCacheExpiryPanel cacheExpiryPanel = new ProjectCacheExpiryPanel(this.getApplicationContext(), this.buildCacheExpiryHolder());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)cacheExpiryPanel, constraints);
        this.addHelpTopicId(cacheExpiryPanel, "project.defaults.cacheExpiry");
        JComponent existenceCheckingWidgets = this.buildLabeledComboBox("CACHING_POLICY_EXISTENCE_CHECKING_CHOOSER", this.buildExistenceCheckingComboBoxModel(), this.buildToplinkOptionRenderer());
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, offset.left, 0, offset.right);
        this.add((Component)existenceCheckingWidgets, constraints);
        this.addHelpTopicId(existenceCheckingWidgets, "project.defaults.existenceChecking");
        this.addHelpTopicId(this, "project.defaults.caching");
    }

    private ListCellRenderer buildToplinkOptionRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return ProjectCachingPolicyPanel.this.resourceRepository().getString(((TopLinkOption)value).resourceKey());
            }
        };
    }

    private PropertyValueModel buildCacheExpiryHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            @Override
            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheExpiry();
            }
        };
    }
}

