/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.weaving.AttributeDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.PersistenceWeaver;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;

public class TransformerFactory {
    public static final String WEAVER_DISABLE_CT_NOT_SUPPORTED = "weaver_change_tracking_disabled_not_supported";
    public static final String WEAVER_FOUND_USER_IMPL_CT = "weaver_user_impl_change_tracking";
    public static final String WEAVER_NULL_PROJECT = "weaver_null_project";
    public static final String WEAVER_DISABLE_BY_SYSPROP = "weaver_disable_by_system_property";
    public static final String WEAVER_CLASS_NOT_IN_PROJECT = "weaver_class_not_in_project";
    public static final String WEAVER_PROCESSING_CLASS = "weaver_processing_class";
    public static final String CANNOT_WEAVE_CHANGETRACKING = "cannot_weave_changetracking";
    public static final String CANNOT_WEAVE_VIRTUAL_ONE_TO_ONE = "cannot_weave_virtual_one_to_one";
    protected Session session;
    protected Collection<MetadataClass> entityClasses;
    protected Map<String, ClassDetails> classDetailsMap;
    protected ClassLoader classLoader;
    protected boolean weaveChangeTracking;
    protected boolean weaveLazy;
    protected boolean weaveFetchGroups;
    protected boolean weaveInternal;
    protected boolean weaveRest;

    public static PersistenceWeaver createTransformerAndModifyProject(Session session, Collection<MetadataClass> entityClasses, ClassLoader classLoader, boolean weaveLazy, boolean weaveChangeTracking, boolean weaveFetchGroups, boolean weaveInternal, boolean weaveRest) {
        if (session == null) {
            throw new IllegalArgumentException("Weaver session cannot be null");
        }
        if (session.getProject() == null) {
            ((AbstractSession)session).log(7, "weaver", WEAVER_NULL_PROJECT, null);
            throw new IllegalArgumentException("Weaver session's project cannot be null");
        }
        TransformerFactory tf = new TransformerFactory(session, entityClasses, classLoader, weaveLazy, weaveChangeTracking, weaveFetchGroups, weaveInternal, weaveRest);
        tf.buildClassDetailsAndModifyProject();
        return tf.buildPersistenceWeaver();
    }

    public TransformerFactory(Session session, Collection<MetadataClass> entityClasses, ClassLoader classLoader, boolean weaveLazy, boolean weaveChangeTracking, boolean weaveFetchGroups, boolean weaveInternal, boolean weaveRest) {
        this.session = session;
        this.entityClasses = entityClasses;
        this.classLoader = classLoader;
        this.classDetailsMap = new HashMap<String, ClassDetails>();
        this.weaveLazy = weaveLazy;
        this.weaveChangeTracking = weaveChangeTracking;
        this.weaveFetchGroups = weaveFetchGroups;
        this.weaveInternal = weaveInternal;
        this.weaveRest = weaveRest;
    }

    public void addClassDetailsForMappedSuperClasses(MetadataClass clz, ClassDescriptor initialDescriptor, ClassDetails classDetails, Map classDetailsMap, List unMappedAttributes, boolean weaveChangeTracking) {
        ClassDescriptor descriptor;
        MetadataClass superClz = clz.getSuperclass();
        if (superClz == null || superClz.isObject()) {
            return;
        }
        ClassDescriptor mappedSuperclassDescriptor = ((AbstractSession)this.session).getMappedSuperclass(superClz.getName());
        if (mappedSuperclassDescriptor == null && (descriptor = this.findDescriptor(this.session.getProject(), clz.getSuperclass().getName())) != null) {
            return;
        }
        boolean weaveValueHolders = this.canWeaveValueHolders(superClz, unMappedAttributes);
        List stillUnMappedMappings = null;
        ClassDetails superClassDetails = this.createClassDetails(superClz, weaveValueHolders, weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal, this.weaveRest);
        superClassDetails.setIsMappedSuperClass(true);
        if (mappedSuperclassDescriptor != null && !mappedSuperclassDescriptor.usesPropertyAccessForWeaving()) {
            superClassDetails.useAttributeAccess();
        } else if (!initialDescriptor.usesPropertyAccessForWeaving()) {
            superClassDetails.useAttributeAccess();
        }
        if (!classDetailsMap.containsKey(superClassDetails.getClassName())) {
            stillUnMappedMappings = this.storeAttributeMappings(superClz, superClassDetails, unMappedAttributes, weaveValueHolders);
            classDetailsMap.put(superClassDetails.getClassName(), superClassDetails);
            this.addClassDetailsForMappedSuperClasses(superClz, initialDescriptor, classDetails, classDetailsMap, stillUnMappedMappings, weaveChangeTracking);
        }
    }

    public PersistenceWeaver buildPersistenceWeaver() {
        return new PersistenceWeaver(this.classDetailsMap);
    }

    public void buildClassDetailsAndModifyProject() {
        if (this.entityClasses != null && this.entityClasses.size() > 0) {
            for (MetadataClass metaClass : this.entityClasses) {
                ClassDescriptor descriptor = this.findDescriptor(this.session.getProject(), metaClass.getName());
                if (descriptor == null) {
                    this.log(2, WEAVER_CLASS_NOT_IN_PROJECT, new Object[]{metaClass.getName()});
                    continue;
                }
                this.log(2, WEAVER_PROCESSING_CLASS, new Object[]{metaClass.getName()});
                boolean weaveValueHoldersForClass = this.weaveLazy && this.canWeaveValueHolders(metaClass, descriptor.getMappings());
                boolean weaveChangeTrackingForClass = this.canChangeTrackingBeEnabled(descriptor, metaClass, this.weaveChangeTracking);
                ClassDetails classDetails = this.createClassDetails(metaClass, weaveValueHoldersForClass, weaveChangeTrackingForClass, this.weaveFetchGroups, this.weaveInternal, this.weaveRest);
                if (descriptor.isDescriptorTypeAggregate()) {
                    classDetails.setIsEmbedable(true);
                }
                if (!descriptor.usesPropertyAccessForWeaving()) {
                    classDetails.useAttributeAccess();
                }
                classDetails.getVirtualAccessMethods().addAll(descriptor.getVirtualAttributeMethods());
                List unMappedAttributes = this.storeAttributeMappings(metaClass, classDetails, descriptor.getMappings(), weaveValueHoldersForClass);
                this.classDetailsMap.put(classDetails.getClassName(), classDetails);
                classDetails.setShouldWeaveConstructorOptimization(classDetails.getDescribedClass().getFields().size() - (descriptor.getMappings().size() - unMappedAttributes.size()) <= 0);
                if (classDetails.getSuperClassName() == null) continue;
                this.addClassDetailsForMappedSuperClasses(metaClass, descriptor, classDetails, this.classDetailsMap, unMappedAttributes, this.weaveChangeTracking);
            }
            for (ClassDetails classDetails : this.classDetailsMap.values()) {
                ClassDescriptor descriptor;
                ClassDetails superClassDetails = this.classDetailsMap.get(classDetails.getSuperClassName());
                if (superClassDetails == null && (descriptor = this.findDescriptor(this.session.getProject(), classDetails.getDescribedClass().getName())) != null && descriptor.hasInheritance()) {
                    superClassDetails = this.classDetailsMap.get(descriptor.getInheritancePolicy().getParentClassName());
                }
                if (superClassDetails == null) continue;
                classDetails.setSuperClassDetails(superClassDetails);
            }
            for (ClassDetails classDetails : this.classDetailsMap.values()) {
                classDetails.setShouldWeaveChangeTracking(classDetails.canWeaveChangeTracking());
            }
        }
    }

    protected boolean canChangeTrackingBeEnabled(ClassDescriptor descriptor, MetadataClass clz, boolean globalWeaveChangeTracking) {
        boolean canWeaveChangeTracking;
        if (!globalWeaveChangeTracking) {
            return false;
        }
        if (descriptor.getObjectChangePolicyInternal() != null) {
            if (descriptor.getObjectChangePolicyInternal().isDeferredChangeDetectionPolicy()) {
                return false;
            }
            if (descriptor.getObjectChangePolicyInternal().isObjectChangeTrackingPolicy()) {
                return true;
            }
        }
        if (!(canWeaveChangeTracking = descriptor.supportsChangeTracking(this.session.getProject()))) {
            this.log(4, CANNOT_WEAVE_CHANGETRACKING, new Object[]{descriptor.getJavaClassName()});
        }
        return canWeaveChangeTracking;
    }

    protected boolean wasChangeTrackingAlreadyWeaved(Class clz) {
        Class<?>[] interfaces = clz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            Class<?> c = interfaces[i];
            if (c.getName().equals(PersistenceWeavedChangeTracking.class.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean canWeaveValueHolders(MetadataClass clz, List mappings) {
        boolean weaveValueHolders = false;
        for (DatabaseMapping mapping : mappings) {
            String attributeName = mapping.getAttributeName();
            if (!mapping.isForeignReferenceMapping()) continue;
            ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)mapping;
            MetadataClass typeClass = this.getAttributeTypeFromClass(clz, attributeName, foreignReferenceMapping, true);
            if (!(foreignReferenceMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy) || typeClass == null || typeClass.extendsInterface(ValueHolderInterface.class)) continue;
            weaveValueHolders = true;
        }
        return weaveValueHolders;
    }

    private ClassDetails createClassDetails(MetadataClass metadataClass, boolean weaveValueHolders, boolean weaveChangeTracking, boolean weaveFetchGroups, boolean weaveInternal, boolean weaveRest) {
        String className = Helper.toSlashedClassName(metadataClass.getName());
        String superClassName = Helper.toSlashedClassName(metadataClass.getSuperclass().getName());
        ClassDetails classDetails = new ClassDetails();
        classDetails.setDescribedClass(metadataClass);
        classDetails.setClassName(className);
        classDetails.setSuperClassName(superClassName);
        classDetails.setShouldWeaveValueHolders(weaveValueHolders);
        classDetails.setShouldWeaveChangeTracking(weaveChangeTracking);
        classDetails.setShouldWeaveFetchGroups(weaveFetchGroups);
        classDetails.setShouldWeaveInternal(weaveInternal);
        classDetails.setShouldWeaveREST(weaveRest);
        MetadataMethod method = metadataClass.getMethod("clone", new ArrayList<String>(), false);
        classDetails.setImplementsCloneMethod(method != null);
        return classDetails;
    }

    protected ClassDescriptor findDescriptor(Project project, String className) {
        for (ClassDescriptor descriptor : project.getOrderedDescriptors()) {
            if (!descriptor.getJavaClassName().equals(className)) continue;
            return descriptor;
        }
        return null;
    }

    protected boolean hasFieldInClass(MetadataClass metadataClass, String attributeName) {
        return metadataClass.getField(attributeName) != null;
    }

    private MetadataClass getAttributeDeclaringClass(MetadataClass metadataClass, String attributeName) {
        MetadataField field = metadataClass.getField(attributeName);
        return field.getDeclaringClass();
    }

    private MetadataClass getAttributeTypeFromClass(MetadataClass metadataClass, String attributeName, DatabaseMapping mapping, boolean checkSuperclass) {
        String getterMethod = mapping.getGetMethodName();
        if (mapping.isAbstractDirectMapping() && mapping.getAttributeAccessor().isVirtualAttributeAccessor()) {
            return metadataClass.getMetadataClass(((AbstractDirectMapping)mapping).getAttributeClassificationName());
        }
        if (mapping != null && getterMethod != null) {
            MetadataMethod method = metadataClass.getMethod(getterMethod, new ArrayList<String>(), checkSuperclass);
            if (method == null) {
                return null;
            }
            return method.getMetadataClass(method.getReturnType());
        }
        MetadataField field = metadataClass.getField(attributeName, checkSuperclass);
        if (field == null) {
            return null;
        }
        return field.getMetadataClass(field.getType());
    }

    protected List storeAttributeMappings(MetadataClass metadataClass, ClassDetails classDetails, List mappings, boolean weaveValueHolders) {
        ArrayList<DatabaseMapping> unMappedAttributes = new ArrayList<DatabaseMapping>();
        HashMap<String, AttributeDetails> attributesMap = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> settersMap = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> gettersMap = new HashMap<String, AttributeDetails>();
        for (DatabaseMapping mapping : mappings) {
            MetadataClass typeClass;
            if (mapping.isMultitenantPrimaryKeyMapping()) continue;
            String attribute = mapping.getAttributeName();
            AttributeDetails attributeDetails = new AttributeDetails(attribute, mapping);
            if (mapping.getAttributeAccessor().isVirtualAttributeAccessor()) {
                attributeDetails.setVirtualProperty(mapping.getAttributeAccessor().isVirtualAttributeAccessor());
                if (classDetails.getInfoForVirtualGetMethod(mapping.getGetMethodName()) == null && classDetails.getInfoForVirtualSetMethod(mapping.getSetMethodName()) == null) {
                    VirtualAttributeMethodInfo info = new VirtualAttributeMethodInfo(mapping.getGetMethodName(), mapping.getSetMethodName());
                    classDetails.getVirtualAccessMethods().add(info);
                }
            }
            if ((typeClass = this.getAttributeTypeFromClass(metadataClass, attribute, mapping, false)) == null) {
                attributeDetails.setAttributeOnSuperClass(true);
                unMappedAttributes.add(mapping);
            }
            if (mapping.getGetMethodName() != null) {
                gettersMap.put(mapping.getGetMethodName(), attributeDetails);
                attributeDetails.setGetterMethodName(mapping.getGetMethodName());
                if (mapping.getSetMethodName() != null) {
                    settersMap.put(mapping.getSetMethodName(), attributeDetails);
                    attributeDetails.setSetterMethodName(mapping.getSetMethodName());
                }
                if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).requiresTransientWeavedFields()) {
                    attributeDetails.setWeaveTransientFieldValueHolders();
                }
                if (this.weaveInternal) {
                    attributeDetails.setHasField(this.hasFieldInClass(metadataClass, attribute));
                }
            } else {
                attributeDetails.setHasField(true);
            }
            if (attributeDetails.hasField()) {
                attributeDetails.setDeclaringType(Type.getType(this.getAttributeDeclaringClass(metadataClass, attribute).getTypeName()));
            }
            if (mapping.isForeignReferenceMapping()) {
                ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)mapping;
                attributeDetails.setReferenceClassName(foreignReferenceMapping.getReferenceClassName());
                if (attributeDetails.getReferenceClassName() != null) {
                    MetadataClass referenceClass = metadataClass.getMetadataFactory().getMetadataClass(attributeDetails.getReferenceClassName());
                    attributeDetails.setReferenceClassType(Type.getType(referenceClass.getTypeName()));
                }
                if (typeClass == null) {
                    typeClass = this.getAttributeTypeFromClass(metadataClass, attribute, foreignReferenceMapping, true);
                }
                if (weaveValueHolders && foreignReferenceMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy && typeClass != null && !typeClass.extendsInterface(ValueHolderInterface.class)) {
                    if (mapping.isObjectReferenceMapping() && attributeDetails.isVirtualProperty()) {
                        classDetails.setShouldWeaveValueHolders(false);
                        this.log(6, CANNOT_WEAVE_VIRTUAL_ONE_TO_ONE, new Object[]{classDetails.getClassName(), attributeDetails.getAttributeName()});
                    } else {
                        attributeDetails.weaveVH(weaveValueHolders, foreignReferenceMapping);
                    }
                }
            }
            if (attributeDetails.getReferenceClassType() == null && typeClass == null) {
                typeClass = this.getAttributeTypeFromClass(metadataClass, attribute, mapping, true);
            }
            if (typeClass != null) {
                attributeDetails.setReferenceClassName(typeClass.getName());
                attributeDetails.setReferenceClassType(Type.getType(typeClass.getTypeName()));
            }
            attributesMap.put(attribute, attributeDetails);
        }
        classDetails.setAttributesMap(attributesMap);
        classDetails.setGetterMethodToAttributeDetails(gettersMap);
        classDetails.setSetterMethodToAttributeDetails(settersMap);
        return unMappedAttributes;
    }

    protected void log(int level, String msg, Object[] params) {
        ((AbstractSession)this.session).log(level, "weaver", msg, params);
    }
}

