/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedcache;

import java.rmi.registry.LocateRegistry;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public abstract class DistributedCacheMergeTest
extends TestCase {
    private OptimisticLockingPolicy policy1 = null;
    private OptimisticLockingPolicy policy2 = null;
    protected Server cluster1Session = null;
    protected Server cluster2Session = null;
    protected Session originalSession = null;
    public static ConcurrencyManager semaphore = new ConcurrencyManager();
    Object originalObject = null;
    int initialNumProjs;

    public DistributedCacheMergeTest() {
        this.setDescription("Testing");
    }

    protected void setup() throws Exception {
        this.originalSession = this.getExecutor().getSession();
        this.originalSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        this.createObject();
        try {
            LocateRegistry.createRegistry(41099);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cluster1Session = this.buildSession("cluster1");
        this.cluster1Session.login();
        this.cluster2Session = this.buildSession("cluster2");
        this.cluster2Session.login();
        Thread.sleep(5000L);
        this.policy1 = this.disableOptimisticLocking(this.cluster1Session);
        this.policy2 = this.disableOptimisticLocking(this.cluster2Session);
    }

    protected void createObject() {
        this.originalObject = this.getOriginalObject();
        UnitOfWork uow = this.originalSession.acquireUnitOfWork();
        Object newObj = uow.registerNewObject(this.originalObject);
        uow.commit();
    }

    protected Server buildSession(String sessionName) throws Exception {
        ServerSession session = null;
        Project p = this.getNewProject();
        DatabaseLogin theLogin = this.originalSession.getLogin();
        p.setLogin(this.originalSession.getLogin());
        session = (ServerSession)p.createServerSession();
        session.setSessionLog(this.getSession().getSessionLog());
        RemoteCommandManager cm = new RemoteCommandManager((CommandProcessor)session);
        cm.setShouldPropagateAsynchronously(true);
        cm.getDiscoveryManager().setAnnouncementDelay(0);
        cm.getTransportManager().setNamingServiceType(1);
        cm.setUrl("rmi://localhost:41099");
        session.setShouldPropagateChanges(true);
        cm.setServerPlatform(((DatabaseSession)this.getSession()).getServerPlatform());
        cm.initialize();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return session;
    }

    public void reset() throws Exception {
        int depth = semaphore.getDepth();
        while (depth != 0) {
            semaphore.release();
            depth = semaphore.getDepth();
        }
        UnitOfWorkImpl uow = this.cluster1Session.acquireClientSession().acquireUnitOfWork();
        uow.deleteObject(this.originalObject);
        uow.commit();
        this.enableOptimisticLocking(this.cluster1Session, this.policy1);
        this.enableOptimisticLocking(this.cluster2Session, this.policy2);
        this.cluster1Session.logout();
        this.cluster1Session = null;
        this.cluster2Session.logout();
        this.cluster2Session = null;
    }

    private OptimisticLockingPolicy disableOptimisticLocking(Server server) {
        ClassDescriptor descriptor = server.getDescriptor(this.getRootClass());
        OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
        descriptor.setOptimisticLockingPolicy(null);
        return policy;
    }

    private void enableOptimisticLocking(Server server, OptimisticLockingPolicy policy) {
        ClassDescriptor descriptor = server.getDescriptor(this.getRootClass());
        descriptor.setOptimisticLockingPolicy(policy);
    }

    protected void test() {
        ClientSession clientSession1 = this.cluster1Session.acquireClientSession();
        ClientSession clientSession2 = this.cluster2Session.acquireClientSession();
        this.cluster2Session.getIdentityMapAccessor().initializeAllIdentityMaps();
        this.cluster2Session.getEventManager().addListener(this.buildCacheMergeBlockingListener());
        Object object1 = this.findOriginalObject((Session)clientSession1);
        if (object1 == null) {
            throw new TestErrorException("Employee on Server 1 exists");
        }
        this.initialNumProjs = this.getCollectionSize(object1);
        UnitOfWork uow = clientSession1.acquireUnitOfWork();
        Object newEmpWC = uow.registerObject(object1);
        this.modifyCollection(uow, newEmpWC);
        semaphore.acquire();
        uow.commit();
        if (this.getCollectionSize(object1) != this.initialNumProjs + 1) {
            throw new TestErrorException("Employee has the wrong number of items in the collection; expected:" + (this.initialNumProjs + 1) + " was:" + this.getCollectionSize(object1));
        }
        try {
            while (semaphore.getNumberOfWritersWaiting() == 0) {
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            throw new TestErrorException("Error while getting Thread to sleep", (Throwable)e);
        }
        Object object2 = clientSession2.getIdentityMapAccessor().getFromIdentityMap(object1);
        if (object2 != null) {
            throw new TestErrorException("Employee already exists in Server 2's cache");
        }
        object2 = this.findOriginalObject((Session)clientSession2);
        if (object2 == null) {
            throw new TestErrorException("Employee does not exist in Server 2's cache");
        }
        if (this.getCollectionSize(object2) != this.initialNumProjs + 1) {
            throw new TestErrorException("Employee has the wrong number of items in the collection");
        }
        semaphore.release();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            throw new TestErrorException("Error while getting Thread to sleep", (Throwable)e);
        }
        semaphore.acquire();
        if (this.getCollectionSize(object2) != this.initialNumProjs + 1) {
            if (this.getCollectionSize(object2) == this.initialNumProjs + 2) {
                throw new TestErrorException("Employee has one too many items in the collection after merge");
            }
            throw new TestErrorException("Employee has wrong number of items in the collection after merge");
        }
        semaphore.release();
    }

    protected Class getRootClass() {
        return Employee.class;
    }

    protected Project getNewProject() {
        return new EmployeeProject();
    }

    protected abstract void modifyCollection(UnitOfWork var1, Object var2);

    protected abstract int getCollectionSize(Object var1);

    protected abstract Object buildOriginalObject();

    public Object findOriginalObject(Session session) {
        ReadObjectQuery roq = new ReadObjectQuery(this.originalObject);
        return session.executeQuery((DatabaseQuery)roq);
    }

    protected SessionEventListener buildCacheMergeBlockingListener() {
        return new SessionEventAdapter(){

            public void preDistributedMergeUnitOfWorkChangeSet(SessionEvent event) {
                try {
                    semaphore.acquire();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void postDistributedMergeUnitOfWorkChangeSet(SessionEvent event) {
                semaphore.release();
            }
        };
    }

    public Object getOriginalObject() {
        if (this.originalObject == null) {
            this.originalObject = this.buildOriginalObject();
        }
        return this.originalObject;
    }
}

