/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import org.eclipse.persistence.tools.workbench.platformsmodel.AbstractJDBCTypeToJavaTypeDeclarationMapping;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.w3c.dom.Node;

public final class JavaTypeDeclarationToJDBCTypeMapping
extends AbstractJDBCTypeToJavaTypeDeclarationMapping {
    public static final String JDBC_TYPE_PROPERTY = "jdbcType";

    JavaTypeDeclarationToJDBCTypeMapping(JDBCTypeRepository repository, Node node) throws CorruptXMLException {
        super(repository, node);
    }

    JavaTypeDeclarationToJDBCTypeMapping(JDBCTypeRepository repository, String javaClassName, int arrayDepth, JDBCType jdbcType) {
        super(repository, jdbcType, javaClassName, arrayDepth);
    }

    public void setJDBCType(JDBCType jdbcType) {
        if (jdbcType == null) {
            throw new NullPointerException();
        }
        JDBCType old = this.jdbcType;
        this.jdbcType = jdbcType;
        this.firePropertyChanged(JDBC_TYPE_PROPERTY, old, jdbcType);
    }

    boolean maps(String javaClassName, int arrayDepth) {
        return this.javaTypeDeclaration.equals(javaClassName, arrayDepth);
    }

    @Override
    public int compareTo(Object o) {
        JavaTypeDeclarationToJDBCTypeMapping other = (JavaTypeDeclarationToJDBCTypeMapping)o;
        return this.javaTypeDeclaration.compareTo(other.javaTypeDeclaration);
    }

    @Override
    void write(Node node) {
        this.writeJavaTypeDeclaration(node);
        this.writeJDBCType(node);
        this.writeComment(node);
    }

    @Override
    public void displayStringOn(StringBuffer sb) {
        this.javaTypeDeclaration.displayStringOn(sb);
        sb.append(" => ");
        sb.append(this.jdbcType.getName());
    }
}

