/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.EditableSchemaPropertiesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaDialogUtilities;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class ImportSchemaDialog
extends AbstractValidatingDialog {
    private EditableSchemaPropertiesPanel schemaPanel;
    MWXmlSchemaRepository schemaRepository;
    MWXmlSchema importedSchema;

    ImportSchemaDialog(WorkbenchContext context, MWXmlSchemaRepository schemaRepository) {
        super(context);
        this.schemaRepository = schemaRepository;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.TITLE"));
        this.setSize(550, 325);
        this.getOKAction().setEnabled(false);
    }

    @Override
    protected Component buildMainPanel() {
        this.schemaPanel = this.buildSchemaPanel();
        return this.schemaPanel;
    }

    private EditableSchemaPropertiesPanel buildSchemaPanel() {
        EditableSchemaPropertiesPanel panel = new EditableSchemaPropertiesPanel(this.buildSchemaRepositoryHolder(), (WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
        panel.addPropertyChangeListener("SCHEMA_PROPERTY", this.buildSchemaPropertyChangeListener());
        return panel;
    }

    private PropertyValueModel buildSchemaRepositoryHolder() {
        return new AbstractReadOnlyPropertyValueModel(){

            @Override
            public Object getValue() {
                return ImportSchemaDialog.this.schemaRepository;
            }
        };
    }

    private PropertyChangeListener buildSchemaPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImportSchemaDialog.this.updateForErrors();
            }
        };
    }

    @Override
    protected String helpTopicId() {
        return "dialog.addSchema";
    }

    public MWXmlSchema promptToImportSchema() {
        this.show();
        return this.importedSchema;
    }

    @Override
    protected void prepareToShow() {
        this.setLocationRelativeTo(this.getParent());
    }

    void updateForErrors() {
        boolean noError;
        boolean bl = noError = this.checkSchemaNameOk() && this.checkLoadMechanismOk();
        if (noError) {
            this.setErrorMessage(null);
        }
        this.getOKAction().setEnabled(noError);
    }

    private boolean checkSchemaNameOk() {
        String schemaName = this.schemaPanel.getSchemaName();
        if (StringTools.stringIsEmpty((String)schemaName)) {
            this.setErrorMessage(this.resourceRepository().getString("SCHEMA_NAME_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        if (this.schemaRepository.getSchema(schemaName) != null || this.schemaRepository.containsSchemaIgnoreCase(schemaName)) {
            this.setErrorMessage(this.resourceRepository().getString("SCHEMA_NAME_NOT_UNIQUE_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkLoadMechanismOk() {
        return this.checkFileMechanismOk() && this.checkUrlMechanismOk() && this.checkClasspathResourceMechanismOk();
    }

    private boolean checkFileMechanismOk() {
        String schemaFileName;
        if (this.schemaPanel.isFileMechanism() && ((schemaFileName = this.schemaPanel.getFileName()) == null || schemaFileName.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("FILE_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkUrlMechanismOk() {
        String schemaUrl;
        if (this.schemaPanel.isUrlMechanism() && ((schemaUrl = this.schemaPanel.getUrl()) == null || schemaUrl.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("URL_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkClasspathResourceMechanismOk() {
        String schemaResourceName;
        if (this.schemaPanel.isClasspathResourceMechanism() && ((schemaResourceName = this.schemaPanel.getClasspathResourceName()) == null || schemaResourceName.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("CLASSPATH_RESOURCE_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean preConfirm() {
        this.startImportationThread();
        return false;
    }

    private void startImportationThread() {
        Thread thread = new Thread((Runnable)new ImportationRunnable(this.buildSchemaCreator()), "XML Schema  Importation");
        thread.setPriority(3);
        thread.start();
    }

    private SchemaCreator buildSchemaCreator() {
        if (this.schemaPanel.isFileMechanism()) {
            return new FileSchemaCreator(this.schemaPanel.getSchemaName(), this.schemaPanel.getFileName());
        }
        if (this.schemaPanel.isUrlMechanism()) {
            return new URLSchemaCreator(this.schemaPanel.getSchemaName(), this.schemaPanel.getUrl());
        }
        if (this.schemaPanel.isClasspathResourceMechanism()) {
            return new ClasspathSchemaCreator(this.schemaPanel.getSchemaName(), this.schemaPanel.getClasspathResourceName());
        }
        throw new IllegalArgumentException();
    }

    void showUrlLoadFailure(String schemaName, ResourceException re) {
        if (this.schemaPanel.isFileMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, schemaName, re, "FILE_RESOURCE", this.schemaPanel.getFileName());
        } else if (this.schemaPanel.isUrlMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, schemaName, re, "URL_RESOURCE", this.schemaPanel.getUrl());
        } else if (this.schemaPanel.isClasspathResourceMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, schemaName, re, "CLASSPATH_RESOURCE", this.schemaPanel.getClasspathResourceName());
        }
        this.getOKAction().setEnabled(false);
    }

    void showSchemaLoadFailure(String schemaName) {
        SchemaDialogUtilities.showSchemaLoadFailure((Component)this, schemaName, null);
        this.getOKAction().setEnabled(false);
    }

    void showSchemaLoadFailure(String schemaName, RuntimeException re) {
        SchemaDialogUtilities.showSchemaLoadFailure((Component)this, schemaName, re);
        this.getOKAction().setEnabled(false);
    }

    @Override
    protected void okConfirmed() {
        super.okConfirmed();
    }

    private class URLSchemaCreator
    extends AbstractSchemaCreator {
        URLSchemaCreator(String schemaName, String fileName) {
            super(schemaName, fileName);
        }

        @Override
        public MWXmlSchema createSchema() throws RuntimeException, ResourceException {
            return ImportSchemaDialog.this.schemaRepository.createSchemaFromUrl(this.schemaName, this.fileName);
        }
    }

    private class FileSchemaCreator
    extends AbstractSchemaCreator {
        FileSchemaCreator(String schemaName, String fileName) {
            super(schemaName, fileName);
        }

        @Override
        public MWXmlSchema createSchema() throws RuntimeException, ResourceException {
            return ImportSchemaDialog.this.schemaRepository.createSchemaFromFile(this.schemaName, this.fileName);
        }
    }

    private class ClasspathSchemaCreator
    extends AbstractSchemaCreator {
        ClasspathSchemaCreator(String schemaName, String fileName) {
            super(schemaName, fileName);
        }

        @Override
        public MWXmlSchema createSchema() throws RuntimeException, ResourceException {
            return ImportSchemaDialog.this.schemaRepository.createSchemaFromClasspath(this.schemaName, this.fileName);
        }
    }

    private abstract class AbstractSchemaCreator
    implements SchemaCreator {
        protected String fileName;
        protected String schemaName;

        AbstractSchemaCreator(String schemaName, String fileName) {
            this.fileName = fileName;
            this.schemaName = schemaName;
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    private static interface SchemaCreator {
        public MWXmlSchema createSchema() throws RuntimeException, ResourceException;

        public String getSchemaName();

        public String getFileName();
    }

    private class ImportationRunnable
    implements Runnable {
        WaitDialog waitDialog;
        SchemaCreator schemaCreator;

        ImportationRunnable(SchemaCreator schemaCreator) {
            this.initialize(schemaCreator);
        }

        private void initialize(SchemaCreator sc) {
            this.schemaCreator = sc;
            this.waitDialog = new WaitDialog((Dialog)ImportSchemaDialog.this.getWorkbenchContext().getCurrentWindow(), ImportSchemaDialog.this.resourceRepository().getIcon("file.xml.large"), ImportSchemaDialog.this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.TITLE"), ImportSchemaDialog.this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.DESCRIPTION", sc.getSchemaName()));
        }

        private void showWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportSchemaDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ImportSchemaDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }

        private void hideWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportSchemaDialog.this.setCursor(Cursor.getDefaultCursor());
                    ImportSchemaDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        private void completeTermination(MWXmlSchema schema) {
            ImportSchemaDialog.this.importedSchema = schema;
            this.disposeImportSchemaDialog();
        }

        private void disposeImportSchemaDialog() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportSchemaDialog.this.okConfirmed();
                }
            });
        }

        @Override
        public void run() {
            try {
                MWXmlSchema schema = this.importSchema();
                this.completeTermination(schema);
            }
            catch (ResourceException re) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportSchemaDialog.this.showUrlLoadFailure(ImportationRunnable.this.schemaCreator.getSchemaName(), re);
                    }
                });
            }
            catch (RuntimeException re) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportSchemaDialog.this.showSchemaLoadFailure(ImportationRunnable.this.schemaCreator.getSchemaName(), re);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MWXmlSchema importSchema() throws RuntimeException, ResourceException {
            this.showWaitCursor();
            AbstractDialog.launchLater(this.waitDialog);
            try {
                MWXmlSchema mWXmlSchema = this.schemaCreator.createSchema();
                return mWXmlSchema;
            }
            finally {
                this.hideWaitCursor();
                this.waitDialog.dispose();
            }
        }
    }
}

