/*******************************************************************************
* Copyright (c) 2016 Oracle and/or its affiliates. All rights reserved.
* This program and the accompanying materials are made available under the
* terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
* which accompanies this distribution.
* The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
* and the Eclipse Distribution License is available at
* http://www.eclipse.org/org/documents/edl-v10.php.
*
* Contributors:
*     Ondrej Cerny
******************************************************************************/
package org.eclipse.persistence.testing.jaxb.annotations.xmlschema.model.base;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import org.eclipse.persistence.testing.jaxb.annotations.xmlschema.model.extended.ExtendedObject;

@XmlSeeAlso({ ExtendedObject.class })
@XmlRootElement
public class BaseObject {
    public String stringField;

    @Override
    public int hashCode() {
        // generated by Eclipse IDE
        final int prime = 31;
        int result = 1;
        result = prime * result + ((stringField == null) ? 0 : stringField.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        // generated by Eclipse IDE
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseObject)) {
            return false;
        }
        BaseObject other = (BaseObject) obj;
        if (stringField == null) {
            if (other.stringField != null) {
                return false;
            }
        } else if (!stringField.equals(other.stringField)) {
            return false;
        }
        return true;
    }
}
