/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class SimpleNullTest
extends JPQLTestCase {
    Employee nullTestEmployee = null;

    public Employee buildNullTestEmployee() {
        Employee employee = new Employee();
        employee.setFirstName(null);
        employee.setLastName("Smith");
        employee.setSalary(10000);
        return employee;
    }

    @Override
    public void setup() {
        this.getDatabaseSession().writeObject((Object)this.getNullTestEmployee());
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull();
        raq.setSelectionCriteria(whereClause);
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)raq));
        this.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName IS NULL");
        super.setup();
    }

    public Employee getNullTestEmployee() {
        if (this.nullTestEmployee == null) {
            this.setNullTestEmployee(this.buildNullTestEmployee());
        }
        return this.nullTestEmployee;
    }

    @Override
    public void reset() {
        this.getDatabaseSession().deleteObject((Object)this.getNullTestEmployee());
        super.reset();
    }

    public void setNullTestEmployee(Employee newEmployee) {
        this.nullTestEmployee = newEmployee;
    }
}

