/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class ReadObjectQueryConformExpiryTest
extends CacheExpiryTest {
    protected Employee employee = null;

    public ReadObjectQueryConformExpiryTest() {
        this.setDescription("Test to ensure expired objects are still returned when conform results is used.");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        ExpressionBuilder empBuilder = new ExpressionBuilder();
        Expression readExpression = empBuilder.get("firstName").equal((Object)this.employee.getFirstName());
        readExpression = readExpression.and(empBuilder.get("lastName").equal((Object)this.employee.getLastName()));
        readExpression = readExpression.and(empBuilder.get("address").get("street").equal((Object)this.employee.getAddress().getStreet()));
        this.employee.setLastName("Blah");
        this.employee.getAddress().setPostalCode("000000");
        uow.getIdentityMapAccessor().invalidateObject((Object)this.employee.getAddress());
        uow.getIdentityMapAccessor().invalidateObject((Object)this.employee);
        Expression emp = empBuilder.get("id").equal((Object)this.employee.getId());
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, emp);
        query.conformResultsInUnitOfWork();
        this.employee = (Employee)uow.executeQuery((DatabaseQuery)query);
        uow.release();
    }

    public void verify() {
        if (!this.employee.getLastName().equals("Blah") || !this.employee.getAddress().getPostalCode().equals("000000")) {
            throw new TestErrorException("Expired objects were not returned when conform resutls is used.");
        }
    }
}

