/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;

public class CombinedClassDescriptionRepository
implements ClassDescriptionRepository {
    protected MWClassRepository repository;
    protected Filter typeNameFilter;
    protected boolean returnsDuplicateClassNames;
    protected Set typeNames;

    public CombinedClassDescriptionRepository(MWClassRepository repository, Filter typeNameFilter) {
        this.repository = repository;
        this.typeNameFilter = typeNameFilter;
        this.returnsDuplicateClassNames = false;
    }

    public CombinedClassDescriptionRepository(MWClassRepository repository) {
        this(repository, Filter.NULL_INSTANCE);
    }

    @Override
    public void refreshClassDescriptions() {
        this.typeNames = null;
        this.repository.refreshExternalClassDescriptions();
    }

    @Override
    public Iterator classDescriptions() {
        return this.filteredCombinedTypes(this.repository.combinedTypes());
    }

    public void setReturnsDuplicateClassNames(boolean returnsDuplicateClassNames) {
        this.returnsDuplicateClassNames = returnsDuplicateClassNames;
    }

    public boolean returnsDuplicateClassNames() {
        return this.returnsDuplicateClassNames;
    }

    protected Iterator filteredCombinedTypes(Iterator combinedTypes) {
        return new FilteringIterator(combinedTypes){

            protected boolean accept(Object o) {
                return CombinedClassDescriptionRepository.this.accept(((ClassDescription)o).getName());
            }
        };
    }

    protected boolean accept(String typeName) {
        return this.typeNameFilter.accept((Object)typeName) && this.acceptDuplicate(typeName);
    }

    protected boolean acceptDuplicate(String typeName) {
        if (this.returnsDuplicateClassNames) {
            return true;
        }
        if (this.typeNames == null) {
            this.typeNames = new HashSet(10000);
        }
        return this.typeNames.add(typeName);
    }
}

