/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.testing.framework.TestCase;

public class ConfigureJavaSE7IndirectCollectionsTest
extends TestCase {
    public ConfigureJavaSE7IndirectCollectionsTest() {
        this.setDescription("Test the configuration of Java SE 7 indirect collection classes in Java SE 8");
    }

    public void setup() throws Throwable {
        String propertyName = "eclipselink.indirection.javase7-indirect-collections";
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            this.throwWarning("System property: [" + propertyName + "] was not configured");
        } else if (!Boolean.valueOf(propertyValue).booleanValue()) {
            this.throwWarning("System property: [" + propertyName + "] value: [" + propertyValue + "] was false or is invalid");
        }
    }

    public void test() throws Throwable {
        ConfigureJavaSE7IndirectCollectionsTest.assertSame((String)"IndirectCollectionsFactory IndirectList class should be org.eclipse.persistence.indirection.IndirectList", IndirectList.class, (Object)IndirectCollectionsFactory.IndirectList_Class);
        ConfigureJavaSE7IndirectCollectionsTest.assertSame((String)"IndirectCollectionsFactory IndirectSet class should be org.eclipse.persistence.indirection.IndirectSet", IndirectSet.class, (Object)IndirectCollectionsFactory.IndirectSet_Class);
        ConfigureJavaSE7IndirectCollectionsTest.assertSame((String)"IndirectCollectionsFactory IndirectMap class should be org.eclipse.persistence.indirection.IndirectMap", IndirectMap.class, (Object)IndirectCollectionsFactory.IndirectMap_Class);
    }
}

