/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.optimisticlocking;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.optimisticlocking.Camera;
import org.eclipse.persistence.testing.models.optimisticlocking.Controller;
import org.eclipse.persistence.testing.models.optimisticlocking.Cooking;
import org.eclipse.persistence.testing.models.optimisticlocking.Gamer;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsole;
import org.eclipse.persistence.testing.models.optimisticlocking.Knitting;
import org.eclipse.persistence.testing.models.optimisticlocking.PowerSupplyUnit;
import org.eclipse.persistence.testing.models.optimisticlocking.Skill;

public class GamesConsoleProject
extends Project {
    public GamesConsoleProject() {
        this.setName("GamesConsoleSystem");
        this.applyLogin();
        this.addDescriptor(this.buildCameraClassDescriptor());
        this.addDescriptor(this.buildControllerClassDescriptor());
        this.addDescriptor(this.buildGamerClassDescriptor());
        this.addDescriptor(this.buildGamesConsoleClassDescriptor());
        this.addDescriptor(this.buildKnittingClassDescriptor());
        this.addDescriptor(this.buildPowerSupplyUnitClassDescriptor());
        this.addDescriptor(this.buildCookingClassDescriptor());
        this.addDescriptor(this.buildSkillClassDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        login.usePlatform((DatabasePlatform)new OraclePlatform());
        login.setDriverClassName("null");
        login.setConnectionString("null");
        login.setUserName("");
        this.setDatasourceLogin((Login)login);
    }

    public ClassDescriptor buildCameraClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Camera.class);
        descriptor.addTableName("OL_CAMERA");
        descriptor.addPrimaryKeyFieldName("OL_CAMERA.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OL_CAMERA.ID");
        descriptor.setSequenceNumberName("OL_CAMERA_SEQ");
        descriptor.setAlias("Camera");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("OL_CAMERA.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OL_CAMERA.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("OL_CAMERA.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping updatedMapping = new DirectToFieldMapping();
        updatedMapping.setAttributeName("updated");
        updatedMapping.setFieldName("OL_CAMERA.UPDATED");
        descriptor.addMapping((DatabaseMapping)updatedMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("OL_CAMERA.VERSION");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        return descriptor;
    }

    public ClassDescriptor buildControllerClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Controller.class);
        descriptor.addTableName("OL_CONTROLLER");
        descriptor.addPrimaryKeyFieldName("OL_CONTROLLER.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OL_CONTROLLER.ID");
        descriptor.setSequenceNumberName("OL_CONTROLLER_SEQ");
        descriptor.setAlias("Controller");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("OL_CONTROLLER.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OL_CONTROLLER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("OL_CONTROLLER.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping updatedMapping = new DirectToFieldMapping();
        updatedMapping.setAttributeName("updated");
        updatedMapping.setFieldName("OL_CONTROLLER.UPDATED");
        descriptor.addMapping((DatabaseMapping)updatedMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("OL_CONTROLLER.VERSION");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        OneToOneMapping consoleMapping = new OneToOneMapping();
        consoleMapping.setAttributeName("console");
        consoleMapping.setReferenceClass(GamesConsole.class);
        consoleMapping.useBasicIndirection();
        consoleMapping.addForeignKeyFieldName("OL_CONTROLLER.CONSOLE_ID", "OL_CONSOLE.ID");
        descriptor.addMapping((DatabaseMapping)consoleMapping);
        return descriptor;
    }

    public ClassDescriptor buildGamerClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Gamer.class);
        descriptor.addTableName("OL_GAMER");
        descriptor.addPrimaryKeyFieldName("OL_GAMER.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OL_GAMER.ID");
        descriptor.setSequenceNumberName("OL_GAMER_SEQ");
        descriptor.setAlias("Gamer");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("OL_GAMER.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OL_GAMER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("OL_GAMER.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping updatedMapping = new DirectToFieldMapping();
        updatedMapping.setAttributeName("updated");
        updatedMapping.setFieldName("OL_GAMER.UPDATED");
        descriptor.addMapping((DatabaseMapping)updatedMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("OL_GAMER.VERSION");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        VariableOneToOneMapping skillMapping = new VariableOneToOneMapping();
        skillMapping.setAttributeName("skill");
        skillMapping.setReferenceClass(Skill.class);
        skillMapping.useProxyIndirection();
        skillMapping.addForeignQueryKeyName("OL_GAMER.SKILL_ID", "id");
        skillMapping.setTypeFieldName("OL_GAMER.SKILL_INDICATOR");
        skillMapping.addClassIndicator(Knitting.class, (Object)"Knitting");
        skillMapping.addClassIndicator(Cooking.class, (Object)"Pwning");
        descriptor.addMapping((DatabaseMapping)skillMapping);
        return descriptor;
    }

    public ClassDescriptor buildGamesConsoleClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(GamesConsole.class);
        descriptor.addTableName("OL_CONSOLE");
        descriptor.addPrimaryKeyFieldName("OL_CONSOLE.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OL_CONSOLE.ID");
        descriptor.setSequenceNumberName("OL_CONSOLE_SEQ");
        descriptor.setAlias("GamesConsole");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("OL_CONSOLE.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OL_CONSOLE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("OL_CONSOLE.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping updatedMapping = new DirectToFieldMapping();
        updatedMapping.setAttributeName("updated");
        updatedMapping.setFieldName("OL_CONSOLE.UPDATED");
        descriptor.addMapping((DatabaseMapping)updatedMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("OL_CONSOLE.VERSION");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        AggregateObjectMapping psuMapping = new AggregateObjectMapping();
        psuMapping.setAttributeName("psu");
        psuMapping.setReferenceClass(PowerSupplyUnit.class);
        psuMapping.setIsNullAllowed(true);
        psuMapping.addFieldNameTranslation("OL_CONSOLE.PSU_SERIAL", "serialNumber->DIRECT");
        psuMapping.addFieldNameTranslation("OL_CONSOLE.PSU_ON", "on->DIRECT");
        descriptor.addMapping((DatabaseMapping)psuMapping);
        OneToOneMapping cameraMapping = new OneToOneMapping();
        cameraMapping.setAttributeName("camera");
        cameraMapping.setReferenceClass(Camera.class);
        cameraMapping.useBasicIndirection();
        cameraMapping.addForeignKeyFieldName("OL_CONSOLE.CAMERA_ID", "OL_CAMERA.ID");
        descriptor.addMapping((DatabaseMapping)cameraMapping);
        OneToManyMapping controllersMapping = new OneToManyMapping();
        controllersMapping.setAttributeName("controllers");
        controllersMapping.setReferenceClass(Controller.class);
        controllersMapping.useTransparentCollection();
        controllersMapping.useCollectionClass(IndirectList.class);
        controllersMapping.addTargetForeignKeyFieldName("OL_CONTROLLER.CONSOLE_ID", "OL_CONSOLE.ID");
        descriptor.addMapping((DatabaseMapping)controllersMapping);
        ManyToManyMapping gamersMapping = new ManyToManyMapping();
        gamersMapping.setAttributeName("gamers");
        gamersMapping.setReferenceClass(Gamer.class);
        gamersMapping.useTransparentCollection();
        gamersMapping.useCollectionClass(IndirectList.class);
        gamersMapping.setRelationTableName("OL_CONSOLE_OL_GAMER");
        gamersMapping.addSourceRelationKeyFieldName("OL_CONSOLE_OL_GAMER.GAMER_ID", "OL_CONSOLE.ID");
        gamersMapping.addTargetRelationKeyFieldName("OL_CONSOLE_OL_GAMER.CONSOLE_ID", "OL_GAMER.ID");
        descriptor.addMapping((DatabaseMapping)gamersMapping);
        return descriptor;
    }

    public ClassDescriptor buildKnittingClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Knitting.class);
        descriptor.addTableName("OL_SKILL");
        descriptor.addPrimaryKeyFieldName("OL_SKILL.ID");
        descriptor.getInterfacePolicy().addParentInterface(Skill.class);
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OL_SKILL.ID");
        descriptor.setSequenceNumberName("OL_SKILL_SEQ");
        descriptor.setAlias("Knitting");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("OL_SKILL.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OL_SKILL.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("OL_SKILL.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping updatedMapping = new DirectToFieldMapping();
        updatedMapping.setAttributeName("updated");
        updatedMapping.setFieldName("OL_SKILL.UPDATED");
        descriptor.addMapping((DatabaseMapping)updatedMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("OL_SKILL.VERSION");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        return descriptor;
    }

    public ClassDescriptor buildPowerSupplyUnitClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(PowerSupplyUnit.class);
        descriptor.setAlias("PowerSupplyUnit");
        DirectToFieldMapping onMapping = new DirectToFieldMapping();
        onMapping.setAttributeName("on");
        onMapping.setFieldName("on->DIRECT");
        ObjectTypeConverter onMappingConverter = new ObjectTypeConverter();
        onMappingConverter.setDefaultAttributeValue((Object)new Boolean("false"));
        onMappingConverter.addConversionValue((Object)new Character('F'), (Object)new Boolean("false"));
        onMappingConverter.addConversionValue((Object)new Character('T'), (Object)new Boolean("true"));
        onMapping.setConverter((Converter)onMappingConverter);
        descriptor.addMapping((DatabaseMapping)onMapping);
        DirectToFieldMapping serialNumberMapping = new DirectToFieldMapping();
        serialNumberMapping.setAttributeName("serialNumber");
        serialNumberMapping.setFieldName("serialNumber->DIRECT");
        descriptor.addMapping((DatabaseMapping)serialNumberMapping);
        return descriptor;
    }

    public ClassDescriptor buildCookingClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Cooking.class);
        descriptor.addTableName("OL_SKILL");
        descriptor.addPrimaryKeyFieldName("OL_SKILL.ID");
        descriptor.getInterfacePolicy().addParentInterface(Skill.class);
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("OL_SKILL.ID");
        descriptor.setSequenceNumberName("OL_SKILL_SEQ");
        descriptor.setAlias("Cooking");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("OL_SKILL.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("OL_SKILL.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("OL_SKILL.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping updatedMapping = new DirectToFieldMapping();
        updatedMapping.setAttributeName("updated");
        updatedMapping.setFieldName("OL_SKILL.UPDATED");
        descriptor.addMapping((DatabaseMapping)updatedMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("OL_SKILL.VERSION");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        return descriptor;
    }

    public ClassDescriptor buildSkillClassDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsForInterface();
        descriptor.setJavaClass(Skill.class);
        descriptor.setAlias("Skill");
        descriptor.addAbstractQueryKey("id");
        descriptor.addAbstractQueryKey("updated");
        descriptor.addAbstractQueryKey("description");
        descriptor.addAbstractQueryKey("version");
        descriptor.addAbstractQueryKey("name");
        return descriptor;
    }
}

