/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.inheritance.Car;

public class OverrideInheritedMappingTest
extends TestCase {
    private Car theCar;
    private Number carID;

    public OverrideInheritedMappingTest() {
        this.setDescription("Subclass is able to override inherited mapping");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.theCar = Car.example4();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.theCar);
        uow.commit();
        Car carRead = (Car)this.getSession().readObject((Object)this.theCar);
        this.carID = carRead.id;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void verify() {
        this.getSession().executeNonSelectingCall((Call)new SQLCall("UPDATE CAR SET FUEL_CAP = 200 WHERE (ID = " + this.carID + ")"));
        Car carRead = (Car)this.getSession().readObject(Car.class, new ExpressionBuilder().get("id").equal((Object)this.carID));
        if (carRead.fuelCapacity != 200) {
            throw new TestErrorException("The inherited mapping was not overridden!");
        }
    }
}

