/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.interfaces;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.testing.models.interfaces.CourseDeveloper;
import org.eclipse.persistence.testing.models.interfaces.Job;
import org.eclipse.persistence.testing.models.interfaces.ManagerialJob;
import org.eclipse.persistence.testing.models.interfaces.ProductDeveloper;
import org.eclipse.persistence.testing.models.interfaces.ProductManager;
import org.eclipse.persistence.testing.models.interfaces.Receptionist;
import org.eclipse.persistence.testing.models.interfaces.Secretary;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class PersonnelManager
implements ManagerialJob,
Serializable {
    public Number jobCode;
    public Float salary;
    public String department;
    public ValueHolderInterface managedEmployees = new ValueHolder();

    public static PersonnelManager example1() {
        PersonnelManager example = new PersonnelManager();
        example.setDepartment("Division A");
        example.setSalary(new Float(77235.0));
        Vector<Job> employees = new Vector<Job>(5);
        employees.addElement(CourseDeveloper.example1());
        employees.addElement(ProductDeveloper.example1());
        employees.addElement(Secretary.example1());
        employees.addElement(Receptionist.example1());
        employees.addElement(ProductManager.example1());
        example.setManagedEmployees(employees);
        return example;
    }

    public static PersonnelManager example2() {
        PersonnelManager example = new PersonnelManager();
        example.setDepartment("Division B");
        example.setSalary(new Float(97235.0));
        Vector<Job> employees = new Vector<Job>(5);
        employees.addElement(CourseDeveloper.example2());
        employees.addElement(ProductDeveloper.example2());
        employees.addElement(Secretary.example2());
        employees.addElement(Receptionist.example2());
        employees.addElement(ProductManager.example2());
        example.setManagedEmployees(employees);
        return example;
    }

    public static PersonnelManager example3() {
        PersonnelManager example = new PersonnelManager();
        example.setDepartment("Division C");
        example.setSalary(new Float(87265.0));
        Vector<Job> employees = new Vector<Job>(5);
        employees.addElement(CourseDeveloper.example3());
        employees.addElement(ProductDeveloper.example3());
        employees.addElement(Secretary.example3());
        employees.addElement(Receptionist.example3());
        employees.addElement(ProductManager.example3());
        example.setManagedEmployees(employees);
        return example;
    }

    public String getDepartment() {
        return this.department;
    }

    @Override
    public Number getJobCode() {
        return this.jobCode;
    }

    @Override
    public Vector getManagedEmployees() {
        return (Vector)this.managedEmployees.getValue();
    }

    @Override
    public Float getSalary() {
        return this.salary;
    }

    public static TableDefinition personnelManagerTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PER_MGR");
        table.addField("CODE", BigDecimal.class, 15);
        table.addField("SALARY", Float.class);
        table.addField("DEPT", String.class, 30);
        return table;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @Override
    public void setJobCode(Number jobCode) {
        this.jobCode = jobCode;
    }

    public void setManagedEmployees(Vector employees) {
        this.managedEmployees.setValue((Object)employees);
    }

    @Override
    public void setSalary(Float salary) {
        this.salary = salary;
    }

    public String toString() {
        return new String("Personnnel Manager: " + this.getJobCode());
    }
}

