/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.beanvalidation;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.exceptions.BeanValidationException;
import org.eclipse.persistence.internal.jpa.metadata.beanvalidation.ReflectionUtils;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetContextClassLoader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidationXMLReader
implements Callable<Map<Class<?>, Boolean>> {
    public static final String DEFAULT_PACKAGE_QNAME = "default-package";
    public static final String BEAN_QNAME = "bean";
    public static final String CONSTRAINT_MAPPING_QNAME = "constraint-mapping";
    public static final String CLASS_QNAME = "class";
    public static final String PACKAGE_SEPARATOR = ".";
    private static final String VALIDATION_XML = "META-INF/validation.xml";
    private static final Logger LOGGER = Logger.getLogger(ValidationXMLReader.class.getName());
    private final List<String> constraintsFiles = new ArrayList<String>(2);
    private Map<Class<?>, Boolean> constraintsOnClasses = new HashMap();
    private SAXParser saxParser;
    private final DefaultHandler validationHandler = new DefaultHandler(){
        private boolean constraintsFileElement = false;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (ValidationXMLReader.CONSTRAINT_MAPPING_QNAME.equalsIgnoreCase(qName)) {
                this.constraintsFileElement = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.constraintsFileElement) {
                ValidationXMLReader.this.constraintsFiles.add(new String(ch, start, length));
                this.constraintsFileElement = false;
            }
        }
    };

    @Override
    public Map<Class<?>, Boolean> call() throws Exception {
        try {
            this.parseValidationXML();
        }
        catch (IOException | SAXException e) {
            String msg = "Parsing of validation.xml failed. Exception: " + e.getMessage();
            LOGGER.warning(msg);
        }
        if (!this.constraintsFiles.isEmpty()) {
            this.parseConstraintFiles();
        }
        return this.constraintsOnClasses;
    }

    public static boolean isValidationXmlPresent() {
        InputStream validationXml = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                validationXml = ((ClassLoader)AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()))).getResourceAsStream(VALIDATION_XML);
            }
            catch (PrivilegedActionException e) {
                String msg = "Loading of META-INF/validation.xml file failed. Exception: " + e.getMessage();
                LOGGER.warning(msg);
            }
        } else {
            validationXml = Thread.currentThread().getContextClassLoader().getResourceAsStream(VALIDATION_XML);
        }
        return validationXml != null;
    }

    private void parseConstraintFiles() {
        DefaultHandler referencedFileHandler = new DefaultHandler(){
            private boolean defaultPackageElement = false;
            private String defaultPackage = "";

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (ValidationXMLReader.DEFAULT_PACKAGE_QNAME.equalsIgnoreCase(qName)) {
                    this.defaultPackageElement = true;
                } else if (ValidationXMLReader.BEAN_QNAME.equalsIgnoreCase(qName)) {
                    String className = String.valueOf(this.defaultPackage) + ValidationXMLReader.PACKAGE_SEPARATOR + attributes.getValue(ValidationXMLReader.CLASS_QNAME);
                    if (LOGGER.isLoggable(Level.INFO)) {
                        String msg = "Detected external constraints on class " + className;
                        LOGGER.info(msg);
                    }
                    try {
                        Class<?> clazz = ReflectionUtils.forName(className);
                        ValidationXMLReader.this.constraintsOnClasses.put(clazz, Boolean.TRUE);
                    }
                    catch (ClassNotFoundException e) {
                        String errMsg = "Loading found class failed. Exception: " + e.getMessage();
                        LOGGER.warning(errMsg);
                    }
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.defaultPackageElement) {
                    this.defaultPackage = new String(ch, start, length);
                    this.defaultPackageElement = false;
                }
            }
        };
        for (String file : this.constraintsFiles) {
            this.parseConstraintFile(file, referencedFileHandler);
        }
    }

    private SAXParser getSaxParser() {
        if (this.saxParser == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                this.saxParser = factory.newSAXParser();
            }
            catch (ParserConfigurationException | SAXException e) {
                String msg = "ValidationXMLReader initialization failed. Exception: " + e.getMessage();
                LOGGER.severe(msg);
                throw new BeanValidationException(msg, (Throwable)e);
            }
        }
        return this.saxParser;
    }

    private void parseValidationXML() throws SAXException, IOException {
        InputStream validationXml = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                validationXml = ((ClassLoader)AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()))).getResourceAsStream(VALIDATION_XML);
            }
            catch (PrivilegedActionException e) {
                String msg = "Loading of META-INF/validation.xml file failed. Exception: " + e.getMessage();
                LOGGER.warning(msg);
            }
        } else {
            validationXml = Thread.currentThread().getContextClassLoader().getResourceAsStream(VALIDATION_XML);
        }
        if (validationXml != null) {
            this.getSaxParser().parse(validationXml, this.validationHandler);
        }
    }

    private void parseConstraintFile(String constraintsFile, DefaultHandler referencedFileHandler) {
        String msg;
        InputStream constraintsXml = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                constraintsXml = ((ClassLoader)AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()))).getResourceAsStream(constraintsFile);
            }
            catch (PrivilegedActionException e) {
                msg = "Loading of custom constraints file: " + constraintsFile + " failed. Exception: " + e.getMessage();
                LOGGER.warning(msg);
            }
        } else {
            constraintsXml = Thread.currentThread().getContextClassLoader().getResourceAsStream(constraintsFile);
        }
        try {
            this.getSaxParser().parse(constraintsXml, referencedFileHandler);
        }
        catch (IOException | NullPointerException | SAXException e) {
            msg = "Loading of custom constraints file: " + constraintsFile + " failed. Exception: " + e.getMessage();
            LOGGER.warning(msg);
        }
    }
}

