/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConversionValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;

public class ObjectTypeConverterMetadata
extends TypeConverterMetadata {
    private List<ConversionValueMetadata> m_conversionValues = new ArrayList<ConversionValueMetadata>();
    private String m_defaultObjectValue;

    public ObjectTypeConverterMetadata() {
        super("<object-type-converter>");
    }

    public ObjectTypeConverterMetadata(MetadataAnnotation objectTypeConverter, MetadataAccessor accessor) {
        super(objectTypeConverter, accessor);
        Object[] objectArray = objectTypeConverter.getAttributeArray("conversionValues");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object conversionValue = objectArray[n2];
            this.m_conversionValues.add(new ConversionValueMetadata((MetadataAnnotation)conversionValue, accessor));
            ++n2;
        }
        this.m_defaultObjectValue = objectTypeConverter.getAttributeString("defaultObjectValue");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ObjectTypeConverterMetadata) {
            ObjectTypeConverterMetadata objectTypeConverter = (ObjectTypeConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_conversionValues, objectTypeConverter.getConversionValues())) {
                return false;
            }
            return this.valuesMatch(this.m_defaultObjectValue, objectTypeConverter.getDefaultObjectValue());
        }
        return false;
    }

    public List<ConversionValueMetadata> getConversionValues() {
        return this.m_conversionValues;
    }

    public String getDefaultObjectValue() {
        return this.m_defaultObjectValue;
    }

    public boolean hasConversionValues() {
        return !this.m_conversionValues.isEmpty();
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        ObjectTypeConverter converter;
        MetadataClass dataType = this.getDataType(accessor, referenceClass);
        MetadataClass objectType = this.getObjectType(accessor, referenceClass);
        if (objectType.isEnum()) {
            converter = new EnumTypeConverter(mapping, objectType.getName());
            objectType = this.getMetadataFactory().getMetadataClass(String.class.getName());
        } else {
            converter = new ObjectTypeConverter(mapping);
        }
        converter.setConverterName(this.getName());
        converter.setDataTypeName(this.getJavaClassName(dataType));
        converter.setObjectTypeName(this.getJavaClassName(objectType));
        HashMap<String, String> dataToObjectValues = new HashMap<String, String>();
        HashMap<String, String> objectToDataValues = new HashMap<String, String>();
        if (this.hasConversionValues()) {
            for (ConversionValueMetadata conversionValue : this.getConversionValues()) {
                String dataValue = conversionValue.getDataValue();
                String objectValue = conversionValue.getObjectValue();
                if (dataToObjectValues.containsKey(dataValue)) {
                    throw ValidationException.multipleObjectValuesForDataValue((Object)accessor.getJavaClass(), (String)this.getName(), (String)dataValue);
                }
                dataToObjectValues.put(dataValue, objectValue);
                if (objectToDataValues.containsKey(objectValue)) continue;
                objectToDataValues.put(objectValue, dataValue);
            }
        }
        for (String dataValue : dataToObjectValues.keySet()) {
            String objectValue = (String)dataToObjectValues.get(dataValue);
            if (objectToDataValues.containsKey(objectValue)) {
                converter.addConversionValueStrings(dataValue, objectValue);
                continue;
            }
            converter.addToAttributeOnlyConversionValueStrings(dataValue, objectValue);
        }
        if (this.m_defaultObjectValue != null && !this.m_defaultObjectValue.equals("")) {
            converter.setDefaultAttributeValueString(this.m_defaultObjectValue);
        }
        this.setConverter(mapping, (Converter)converter, isForMapKey);
    }

    public void setConversionValues(List<ConversionValueMetadata> conversionValues) {
        this.m_conversionValues = conversionValues;
    }

    public void setDefaultObjectValue(String defaultObjectValue) {
        this.m_defaultObjectValue = defaultObjectValue;
    }
}

