/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.LockModeType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicNamedQuery;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a named JPQL query.
 *
 * @see Entity
 * @see ORMConfiguration
 *
 * @version 2.6
 */
final class NamedQuery extends AbstractQuery
                       implements ExternalBasicNamedQuery {

	/**
	 * Creates a new <code>NamedQuery</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned by the parent
	 */
	NamedQuery(AbstractExternalForm parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildElementNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(DESCRIPTION);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return NAMED_QUERY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public LockModeType getLockModeType() {
		return getChildEnumNode(LOCK_MODE, LockModeType.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getLockModeTypeTextRange() {
		return getChildTextNodeTextRange(LOCK_MODE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLockModeType(LockModeType lockModeType) {
		updateChildTextNode(LOCK_MODE, lockModeType);
	}
}