/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface represents a collection of static constants for the jpa, orm xml document.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ORMXmlConstants extends XmlConstants {

	/**
	 * The URI of the EclipseLink ORM namespace.
	 */
	String ECLIPSELINK_ORM_NAMESPACE_URI = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 1.2.
	 */
	String ECLIPSELINK_ORM_XSD_URI_1_2 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_1_2.xsd";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 2.0.
	 */
	String ECLIPSELINK_ORM_XSD_URI_2_0 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_0.xsd";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 2.1.
	 */
	String ECLIPSELINK_ORM_XSD_URI_2_1 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_1.xsd";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 2.2.
	 */
	String ECLIPSELINK_ORM_XSD_URI_2_2 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_2.xsd";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 2.3.
	 */
	String ECLIPSELINK_ORM_XSD_URI_2_3 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_3.xsd";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 2.4.
	 */
	String ECLIPSELINK_ORM_XSD_URI_2_4 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_4.xsd";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 2.5.
	 */
	String ECLIPSELINK_ORM_XSD_URI_2_5 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_5.xsd";

	/**
	 * The URI of the EclipseLink ORM Configuration schema, version ORM 2.6.
	 */
	String ECLIPSELINK_ORM_XSD_URI_2_6 = "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_6.xsd";

	/**
	 * The URI of the ORM namespace.
	 */
	String ORM_NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence/orm";

	/**
	 * The URI of the ORM Configuration schema, JPA 1.0.
	 */
	String ORM_XSD_URI_1_0 = "http://java.sun.com/xml/ns/persistence/orm_1_0.xsd";

	/**
	 * The URI of the ORM Configuration schema, JPA 2.0.
	 */
	String ORM_XSD_URI_2_0 = "http://java.sun.com/xml/ns/persistence/orm_2_0.xsd";

	/**
	 * The URI of the ORM Configuration schema, JPA 2.1.
	 */
	String ORM_XSD_URI_2_1 = "http://java.sun.com/xml/ns/persistence/orm_2_1.xsd";

	/**
	 * Static identifier for the document version 1.2.
	 */
	String VERSION_1_2 = "1.2";

	/**
	 * Static identifier for the document version 2.1.
	 */
	String VERSION_2_1 = "2.1";

	/**
	 * Static identifier for the document version 2.2.
	 */
	String VERSION_2_2 = "2.2";

	/**
	 * Static identifier for the document version 2.3.
	 */
	String VERSION_2_3 = "2.3";

	/**
	 * Static identifier for the document version 2.4.
	 */
	String VERSION_2_4 = "2.4";

	/**
	 * Static identifier for the document version 2.5.
	 */
	String VERSION_2_5 = "2.5";

	/**
	 * Static identifier for the document version 2.6.
	 */
	String VERSION_2_6 = "2.6";
}