/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * Represents a configuration property key/value pair listed in the properties section of a
 * persistence unit defined in the persistence configuration xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalProperty extends ExternalForm {

	/**
	 * The property name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String PROPERTY = "property";

	/**
	 * The property name used to store and retrieve the value property.
	 */
	String VALUE = "value";

	/**
	 * The property name used to store and retrieve the value-type property.
	 */
	String VALUE_TYPE = "value-type";

	/**
	 * Returns the name of the property.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name of the property.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the value string for this property.
	 */
	String getValue();

	/**
	 * Returns the {@link TextRange} for the value of the property.
	 */
	TextRange getValueTextRange();

	/**
	 * Returns the value type string for this property.
	 */
	String getValueType();

	/**
	 * Sets the name for the this property.
	 */
	void setName(String name);

	/**
	 * Sets the value string for this property.
	 */
	void setValue(String value);

	/**
	 * Sets the value type string for this property.
	 */
	void setValueType(String valueType);
}