/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.model.spi.jdbc;

import java.sql.Connection;
import org.eclipse.persistence.tools.db.model.spi.ExternalDatabase;
import org.eclipse.persistence.tools.db.model.spi.ExternalDatabaseFactory;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * Not much to say here: This is a factory for generating instances of
 * the "JDBC" implementation of ExternalDatabase, which uses a
 * java.sql.Connection ExternalTables etc.
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class JDBCExternalDatabaseFactory implements ExternalDatabaseFactory {

	/** the singleton */
	private static ExternalDatabaseFactory INSTANCE;

	/**
	 * Singleton support.
	 */
	public static synchronized ExternalDatabaseFactory instance() {
		if (INSTANCE == null) {
			INSTANCE = new JDBCExternalDatabaseFactory();
		}
		return INSTANCE;
	}

	/**
	 * Private constructor - use the singleton.
	 */
	public JDBCExternalDatabaseFactory() {
		super();
	}

	/**
	 * @see org.eclipse.persistence.tools.db.model.spi.ExternalDatabaseFactory#buildDatabase(java.sql.Connection)
	 */
	@Override
	public ExternalDatabase buildDatabase(Connection connection) {
		return new JDBCExternalDatabase(connection);
	}

	/**
	 * @see Object#toString()
	 */
	@Override
	public String toString() {
		return ObjectTools.toString(this, "singleton");
	}
}