/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessType;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests.AttributeNodeTester;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests.TextNodeTester;

/**
 * Defines the various testers for the "access" property.
 *
 * @see org.eclipse.persistence.tools.mapping.orm.ExternalAccessType
 *
 * @version 2.6
 */
public final class AccessTypeTests {

	/**
	 * Cannot create a new <code>AccessTypeTests</code>.
	 */
	private AccessTypeTests() {
		super();
	}

	public static <T extends ExternalAccessType> AttributeNodeTester<T, AccessType> buildAccessAttributeNodeTester() {
		return new AttributeNodeTester<T, AccessType>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public AccessType getDefaultValue() {
				return AccessType.FIELD;
			}
			@Override
			public String getNodeName() {
				return ExternalAccessType.ACCESS;
			}
			@Override
			public AccessType getValue(ExternalAccessType form) {
				return form.getAccessType();
			}
			@Override
			public AccessType getValue1() {
				return AccessType.PROPERTY;
			}
			@Override
			public AccessType getValue2() {
				return AccessType.VIRTUAL;
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalAccessType form, AccessType value) {
				form.setAccessType(value);
			}
			@Override
			public String toString(AccessType value) {
				return value.name();
			}
		};
	}

	public static <T extends ExternalAccessType> TextNodeTester<T, AccessType> buildAccessTextNodeTester() {
		return new TextNodeTester<T, AccessType>() {
			@Override
			public boolean doesNodeAlreadyExist() {
				return false;
			}
			@Override
			public AccessType getDefaultValue() {
				return AccessType.FIELD;
			}
			@Override
			public String getNodeName() {
				return ExternalAccessType.ACCESS;
			}
			@Override
			public AccessType getValue(ExternalAccessType form) {
				return form.getAccessType();
			}
			@Override
			public AccessType getValue1() {
				return AccessType.PROPERTY;
			}
			@Override
			public AccessType getValue2() {
				return AccessType.VIRTUAL;
			}
			@Override
			public boolean isNodeDeletedWithNullValue() {
				return false;
			}
			@Override
			public boolean isNullAllowed() {
				return true;
			}
			@Override
			public void setValue(ExternalAccessType form, AccessType value) {
				form.setAccessType(value);
			}
			@Override
			public String toString(AccessType value) {
				return value.name();
			}
		};
	}
}