/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.prefs;

import java.util.EventObject;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.Preferences;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public abstract class PreferencesTestCase
extends TestCase {
    protected Preferences classNode;
    public Preferences testNode;
    protected static final String TEST_NODE_NAME = "test node";

    public PreferencesTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Preferences packageNode = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this.classNode = packageNode.node(((Object)((Object)this)).getClass().getSimpleName());
        if (this.classNode.keys().length > 0 || this.classNode.childrenNames().length > 0) {
            this.classNode.removeNode();
            this.classNode = packageNode.node(((Object)((Object)this)).getClass().getSimpleName());
        }
        this.testNode = this.classNode.node(TEST_NODE_NAME);
    }

    protected void tearDown() throws Exception {
        this.waitForEventQueueToClear();
        Preferences node = this.classNode.parent();
        this.classNode.removeNode();
        while (this.nodeIsVestigial(node)) {
            Preferences parent = node.parent();
            node.removeNode();
            node = parent;
        }
        TestTools.clear(this);
        super.tearDown();
    }

    private boolean nodeIsVestigial(Preferences node) throws Exception {
        return node != null && node.keys().length == 0 && node.childrenNames().length == 0 && node != Preferences.userRoot();
    }

    protected void waitForEventQueueToClear() {
        while (!this.preferencesEventQueue().isEmpty()) {
            TestTools.sleep(100L);
        }
        TestTools.sleep(100L);
    }

    private List<EventObject> preferencesEventQueue() {
        return (List)ClassTools.get(AbstractPreferences.class, (String)"eventQueue");
    }
}

