/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.ChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.ChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.ReadOnlyModifiablePropertyValueModelWrapper;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class ReadOnlyModifiablePropertyValueModelWrapperTests
extends TestCase {
    private ModifiablePropertyValueModel<String> objectHolder;
    PropertyChangeEvent event;
    private ModifiablePropertyValueModel<String> wrapperObjectHolder;
    PropertyChangeEvent wrapperEvent;

    public ReadOnlyModifiablePropertyValueModelWrapperTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)"foo");
        this.wrapperObjectHolder = new ReadOnlyModifiablePropertyValueModelWrapper(this.objectHolder);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
        this.objectHolder.setValue((Object)"bar");
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"bar", (String)((String)this.wrapperObjectHolder.getValue()));
        this.objectHolder.setValue(null);
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertNull((Object)this.objectHolder.getValue());
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertNull((Object)this.wrapperObjectHolder.getValue());
        this.objectHolder.setValue((Object)"foo");
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
    }

    public void testSetValue() {
        boolean exceptionOccurred = false;
        try {
            this.wrapperObjectHolder.setValue((Object)"bar");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exceptionOccurred = true;
        }
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertTrue((boolean)exceptionOccurred);
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
    }

    public void testLazyListening() {
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        ChangeListener listener = this.buildWrapperListener();
        this.wrapperObjectHolder.addChangeListener(listener);
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.wrapperObjectHolder.removeChangeListener(listener);
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.wrapperObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.wrapperObjectHolder.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addChangeListener(this.buildListener());
        this.wrapperObjectHolder.addChangeListener(this.buildWrapperListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.wrapperObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildWrapperListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent(this.event, this.objectHolder, "foo", "bar");
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, "foo", "bar");
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue(null);
        this.verifyEvent(this.event, this.objectHolder, "bar", null);
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, "bar", null);
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue((Object)"foo");
        this.verifyEvent(this.event, this.objectHolder, null, "foo");
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, null, "foo");
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                ReadOnlyModifiablePropertyValueModelWrapperTests.this.event = e;
            }
        };
    }

    private ChangeListener buildWrapperListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                ReadOnlyModifiablePropertyValueModelWrapperTests.this.wrapperEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((Object)source, (Object)e.getSource());
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((String)"value", (String)e.getPropertyName());
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        ReadOnlyModifiablePropertyValueModelWrapperTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }
}

