/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.filter;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.BitTools;
import org.eclipse.persistence.tools.utility.filter.ANDFilter;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.filter.FilterAdapter;
import org.eclipse.persistence.tools.utility.filter.SimpleFilter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class ANDFilterTests
extends TestCase {
    private ANDFilter<Number> andFilter;

    public ANDFilterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.andFilter = new ANDFilter(new Filter[]{this.buildMinFilter(1.0), this.buildMaxFilter(10.0)});
    }

    private Filter<Number> buildMinFilter(double min) {
        return new MinFilter(min);
    }

    private Filter<Number> buildMaxFilter(double max) {
        return new MaxFilter(max);
    }

    private Filter<Number> buildEvenFilter() {
        return new EvenFilter();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testFiltering2() {
        ANDFilterTests.assertTrue((boolean)this.andFilter.accept((Object)new Integer(7)));
        ANDFilterTests.assertTrue((boolean)this.andFilter.accept((Object)new Integer(2)));
        ANDFilterTests.assertTrue((boolean)this.andFilter.accept((Object)new Double(6.666)));
        ANDFilterTests.assertFalse((boolean)this.andFilter.accept((Object)new Double(-99.0)));
        ANDFilterTests.assertFalse((boolean)this.andFilter.accept((Object)new Double(-1.0)));
        ANDFilterTests.assertFalse((boolean)this.andFilter.accept((Object)new Double(11.0)));
        ANDFilterTests.assertFalse((boolean)this.andFilter.accept((Object)new Double(111.0)));
    }

    public void testFiltering3() {
        ANDFilter andFilter2 = new ANDFilter(new Filter[]{this.andFilter, this.buildEvenFilter()});
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Integer(7)));
        ANDFilterTests.assertTrue((boolean)andFilter2.accept((Object)new Integer(2)));
        ANDFilterTests.assertTrue((boolean)andFilter2.accept((Object)new Double(6.1)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(-99.0)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(-1.0)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(11.0)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(111.0)));
    }

    public void testFilteringComposite() {
        ANDFilter andFilter2 = new ANDFilter(new Filter[]{this.buildMinFilter(1.0), this.buildMaxFilter(10.0), this.buildEvenFilter()});
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Integer(7)));
        ANDFilterTests.assertTrue((boolean)andFilter2.accept((Object)new Integer(2)));
        ANDFilterTests.assertTrue((boolean)andFilter2.accept((Object)new Double(6.1)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(-99.0)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(-1.0)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(11.0)));
        ANDFilterTests.assertFalse((boolean)andFilter2.accept((Object)new Double(111.0)));
    }

    public void testClone() {
        ANDFilter andFilter2 = (ANDFilter)this.andFilter.clone();
        ANDFilterTests.assertEquals((Object)this.andFilter.getFilters()[0], (Object)andFilter2.getFilters()[0]);
        ANDFilterTests.assertEquals((Object)this.andFilter.getFilters()[1], (Object)andFilter2.getFilters()[1]);
        ANDFilterTests.assertNotSame(this.andFilter, (Object)andFilter2);
    }

    public void testEquals() {
        ANDFilter andFilter2 = new ANDFilter(new Filter[]{this.buildMinFilter(1.0), this.buildMaxFilter(10.0)});
        ANDFilterTests.assertEquals(this.andFilter, (Object)andFilter2);
        ANDFilterTests.assertEquals((int)this.andFilter.hashCode(), (int)andFilter2.hashCode());
    }

    public void testSerialization() throws Exception {
        ANDFilter<Number> andFilter2 = TestTools.serialize(this.andFilter);
        ANDFilterTests.assertEquals((Object)this.andFilter.getFilters()[0], (Object)andFilter2.getFilters()[0]);
        ANDFilterTests.assertEquals((Object)this.andFilter.getFilters()[1], (Object)andFilter2.getFilters()[1]);
        ANDFilterTests.assertNotSame(this.andFilter, andFilter2);
    }

    static class EvenFilter
    extends FilterAdapter<Number> {
        EvenFilter() {
        }

        public boolean accept(Number number) {
            return BitTools.isEven((int)number.intValue());
        }
    }

    static class MaxFilter
    extends SimpleFilter<Number, Number> {
        private static final long serialVersionUID = 1L;

        MaxFilter(double min) {
            super((Object)new Double(min));
        }

        public boolean accept(Number number) {
            return number.doubleValue() <= ((Number)this.criterion).doubleValue();
        }
    }

    static class MinFilter
    extends SimpleFilter<Number, Number> {
        private static final long serialVersionUID = 1L;

        MinFilter(double min) {
            super((Object)new Double(min));
        }

        public boolean accept(Number number) {
            return number.doubleValue() >= ((Number)this.criterion).doubleValue();
        }
    }
}

