/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.node;

import java.util.Arrays;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.node.Node;
import org.eclipse.persistence.tools.utility.node.Problem;

public class DefaultProblem
implements Problem {
    private final Node source;
    private final String messageKey;
    private final int messageType;
    private final Object[] messageArguments;

    DefaultProblem(Node source, String messageKey, int messageType, Object[] messageArguments) {
        if (source == null || messageKey == null || messageArguments == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.messageKey = messageKey;
        this.messageType = messageType;
        this.messageArguments = messageArguments;
    }

    @Override
    public Node source() {
        return this.source;
    }

    @Override
    public String messageKey() {
        return this.messageKey;
    }

    @Override
    public int messageType() {
        return this.messageType;
    }

    @Override
    public Object[] messageArguments() {
        return this.messageArguments;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)o;
        return this.source == other.source() && this.messageKey.equals(other.messageKey()) && Arrays.equals(this.messageArguments, other.messageArguments());
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() ^ this.messageKey.hashCode();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.messageKey);
    }
}

