/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalColumnResult;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityResult;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ColumnResult;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityResult;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class SQLResultSetMapping
extends AbstractExternalForm
implements ExternalSQLResultSetMapping {
    private int index;

    SQLResultSetMapping(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public ExternalColumnResult addColumnResult(String name) {
        ColumnResult entityResult = this.buildColumnResult(-1);
        entityResult.addSelf();
        entityResult.setName(name);
        return entityResult;
    }

    @Override
    public ExternalEntityResult addEntityResult(String className) {
        EntityResult entityResult = this.buildEntityResult(this.index);
        entityResult.addSelf();
        entityResult.setEntityClassName(className);
        return entityResult;
    }

    private ColumnResult buildColumnResult(int index) {
        return new ColumnResult(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("entity-result");
        names.add("column-result");
        return names;
    }

    private EntityResult buildEntityResult(int index) {
        return new EntityResult(this, index);
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public List<ExternalColumnResult> columnResults() {
        int count = this.columnResultsSize();
        ArrayList<ExternalColumnResult> columnResults = new ArrayList<ExternalColumnResult>(count);
        int index = 0;
        while (index < count) {
            columnResults.add(this.buildColumnResult(index));
            ++index;
        }
        return columnResults;
    }

    @Override
    public int columnResultsSize() {
        return this.getChildrenSize("column-result");
    }

    @Override
    public List<ExternalEntityResult> entityResults() {
        int count = this.entityResultsSize();
        ArrayList<ExternalEntityResult> entityResults = new ArrayList<ExternalEntityResult>(count);
        int index = 0;
        while (index < count) {
            entityResults.add(this.buildEntityResult(index));
            ++index;
        }
        return entityResults;
    }

    @Override
    public int entityResultsSize() {
        return this.getChildrenSize("entity-result");
    }

    @Override
    public ExternalColumnResult getColumnResult(int index) {
        if (this.hasChild("column-result", index)) {
            return this.buildColumnResult(index);
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "sql-result-set-mapping";
    }

    @Override
    public ExternalEntityResult getEntityResult(int index) {
        if (this.hasChild("entity-result", index)) {
            return this.buildEntityResult(index);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public void removeColumnResult(int index) {
        EntityResult entityResult = this.buildEntityResult(index);
        entityResult.removeSelf();
    }

    @Override
    public void removeEntityResult(int index) {
        EntityResult entityResult = this.buildEntityResult(index);
        entityResult.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }
}

