/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalCollectionTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Table;

final class CollectionTable
extends Table
implements ExternalCollectionTable {
    CollectionTable(ConvertibleMapping parent) {
        super(parent);
    }

    @Override
    public ExternalJoinColumn addJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn(-1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("catalog");
        names.add("schema");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("join-column");
        names.add("unique-constraint");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, "join-column", index);
    }

    @Override
    protected String getElementName() {
        return "collection-table";
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        if (this.hasChild("join-column", index)) {
            return this.buildJoinColumn(index);
        }
        return null;
    }

    @Override
    public boolean isDefault() {
        return !this.hasAnything();
    }

    @Override
    public List<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn(index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }
}

