/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;

public class IndirectListTestAPI
extends ZTestCase {
    private Vector<String> list;
    private IndirectList<String> testList;

    public IndirectListTestAPI(String name) {
        super(name);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.list = this.setUpList();
        Vector<String> temp = new Vector<String>(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        this.testList = IndirectCollectionsFactory.createIndirectList();
        this.testList.setValueHolder((ValueHolderInterface)vh);
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }

    public void testAdd1() {
        String temp = "foo";
        this.list.add(3, temp);
        this.testList.add(3, (Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testAdd2() {
        String temp = "foo";
        this.list.add(temp);
        this.testList.add((Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testAddAll1() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(temp);
        this.testList.addAll(temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
    }

    public void testAddAll2() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(3, temp);
        this.testList.addAll(3, temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
    }

    public void testAddElement() {
        String temp = "foo";
        this.list.addElement(temp);
        this.testList.addElement((Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testClear() {
        this.list.clear();
        this.testList.clear();
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((this.testList.size() == 0 ? 1 : 0) != 0);
    }

    public void testContains() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)this.list.elementAt(1)));
    }

    public void testContainsAll() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(this.list.subList(1, 5)));
    }

    public void testElementAt() {
        IndirectListTestAPI.assertEquals((String)this.list.elementAt(1), (String)((String)this.testList.elementAt(1)));
    }

    public void testElements() {
        IndirectListTestAPI.assertEquals((String)this.list.elements().nextElement(), (String)((String)this.testList.elements().nextElement()));
    }

    public void testEquals() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.equals(this.list));
    }

    public void testFirstElement() {
        IndirectListTestAPI.assertEquals((String)this.list.firstElement(), (String)((String)this.testList.firstElement()));
    }

    public void testGet() {
        IndirectListTestAPI.assertEquals((String)this.list.get(1), (String)((String)this.testList.get(1)));
    }

    public void testHashCode() {
        IndirectListTestAPI.assertEquals((int)this.list.hashCode(), (int)this.testList.hashCode());
    }

    public void testIndexOf1() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.indexOf(temp), (int)this.testList.indexOf((Object)temp));
    }

    public void testIndexOf2() {
        String temp = "seven";
        IndirectListTestAPI.assertEquals((int)this.list.indexOf(temp, 3), (int)this.testList.indexOf((Object)temp, 3));
    }

    public void testInsertElementAt() {
        String temp = "foo";
        this.list.insertElementAt(temp, 3);
        this.testList.insertElementAt((Object)temp, 3);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testIsEmpty() {
        IndirectListTestAPI.assertTrue((!this.testList.isEmpty() ? 1 : 0) != 0);
    }

    public void testIterator() {
        int i = 0;
        Iterator stream = this.testList.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)i);
    }

    public void testLastElement() {
        IndirectListTestAPI.assertEquals((String)this.list.lastElement(), (String)((String)this.testList.lastElement()));
    }

    public void testLastIndexOf1() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.lastIndexOf(temp), (int)this.testList.lastIndexOf((Object)temp));
    }

    public void testLastIndexOf2() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.lastIndexOf(temp, 7), (int)this.testList.lastIndexOf((Object)temp, 7));
    }

    public void testListIterator1() {
        int i = 0;
        ListIterator stream = this.testList.listIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)i);
    }

    public void testListIterator2() {
        int i = 0;
        ListIterator stream = this.testList.listIterator(2);
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)(i + 2));
    }

    public void testRemove1() {
        String temp = this.list.remove(1);
        IndirectListTestAPI.assertEquals((Object)temp, (Object)this.testList.remove(1));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
    }

    public void testRemove2() {
        String temp = "one";
        IndirectListTestAPI.assertTrue((boolean)this.list.remove(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.remove((Object)temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
    }

    public void testRemoveAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectListTestAPI.assertTrue((boolean)this.list.removeAll(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.removeAll(temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.containsAll(temp) ? 1 : 0) != 0);
    }

    public void testRemoveAllElements() {
        this.list.removeAllElements();
        this.testList.removeAllElements();
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((this.testList.size() == 0 ? 1 : 0) != 0);
    }

    public void testRemoveElement() {
        String temp = "one";
        IndirectListTestAPI.assertTrue((boolean)this.list.removeElement(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.removeElement((Object)temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
    }

    public void testRemoveElementAt() {
        Object temp = this.testList.elementAt(1);
        this.list.removeElementAt(1);
        this.testList.removeElementAt(1);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains(temp) ? 1 : 0) != 0);
    }

    public void testRetainAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectListTestAPI.assertTrue((boolean)this.list.retainAll(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.retainAll(temp));
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        IndirectListTestAPI.assertEquals((int)temp.size(), (int)this.testList.size());
    }

    public void testSet() {
        String temp = "foo";
        this.list.set(3, temp);
        this.testList.set(3, (Object)temp);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testSetElementAt() {
        String temp = "foo";
        this.list.setElementAt(temp, 3);
        this.testList.setElementAt((Object)temp, 3);
        IndirectListTestAPI.assertEquals(this.list, this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testSize() {
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)this.testList.size());
    }

    public void testSubList() {
        IndirectListTestAPI.assertEquals(this.list.subList(2, 5), (Object)this.testList.subList(2, 5));
    }

    public void testToArray1() {
        Object[] temp = this.list.toArray();
        Vector<Object> v1 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = this.testList.toArray();
        Vector<Object> v2 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        IndirectListTestAPI.assertEquals(v1, v2);
    }

    public void testToArray2() {
        String[] temp = this.list.toArray(new String[0]);
        Vector<String> v1 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = (String[])this.testList.toArray((Object[])new String[0]);
        Vector<String> v2 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        IndirectListTestAPI.assertEquals(v1, v2);
    }

    public void testSort() {
        block2: {
            this.assertElementsEqual(this.list, (Vector)this.testList);
            Comparator<String> c = new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            };
            try {
                this.callMethod((List)this.testList, "sort", new Class[]{Comparator.class}, new Object[]{c});
            }
            catch (UnsupportedOperationException e) {
                if (JavaSEPlatform.CURRENT.compareTo((Enum)JavaSEPlatform.v1_8) >= 0) break block2;
                return;
            }
        }
        this.list = new Vector();
        this.list.addElement("eight");
        this.list.addElement("five");
        this.list.addElement("four");
        this.list.addElement("nine");
        this.list.addElement("one");
        this.list.addElement("seven");
        this.list.addElement("six");
        this.list.addElement("three");
        this.list.addElement("two");
        this.list.addElement("zero");
        this.assertElementsEqual(this.list, (Vector)this.testList);
    }

    public void testSpliterator() {
        Object o;
        block3: {
            o = null;
            try {
                o = this.callMethod((List)this.testList, "spliterator", new Class[0], new Object[0]);
            }
            catch (UnsupportedOperationException e) {
                if (JavaSEPlatform.CURRENT.compareTo((Enum)JavaSEPlatform.v1_8) >= 0) break block3;
                return;
            }
        }
        IndirectListTestAPI.assertNotNull((String)"Should get an instance of java.util.Spliterator", o);
        boolean streamFound = false;
        for (Class<?> c : o.getClass().getInterfaces()) {
            if (!"java.util.Spliterator".equals(c.getName())) continue;
            streamFound = true;
            break;
        }
        IndirectListTestAPI.assertTrue((String)"not implementing java.util.Spliterator", (boolean)streamFound);
    }

    public void testStream() {
        Object o;
        block4: {
            o = null;
            try {
                o = this.callMethod((List)this.testList, "stream", new Class[0], new Object[0]);
            }
            catch (UnsupportedOperationException e) {
                if (JavaSEPlatform.CURRENT.compareTo((Enum)JavaSEPlatform.v1_8) >= 0) break block4;
                return;
            }
        }
        IndirectListTestAPI.assertNotNull((String)"Should get an instance of java.util.stream.Stream", o);
        boolean streamFound = false;
        if (o.getClass().getEnclosingClass() != null) {
            for (Class<?> c : o.getClass().getEnclosingClass().getInterfaces()) {
                if (!"java.util.stream.Stream".equals(c.getName())) continue;
                streamFound = true;
                break;
            }
        }
        IndirectListTestAPI.assertTrue((String)"not implementing java.util.stream.Stream", (boolean)streamFound);
    }

    public void testParallelStream() {
        Object o;
        block4: {
            o = null;
            try {
                o = this.callMethod((List)this.testList, "parallelStream", new Class[0], new Object[0]);
            }
            catch (UnsupportedOperationException e) {
                if (JavaSEPlatform.CURRENT.compareTo((Enum)JavaSEPlatform.v1_8) >= 0) break block4;
                return;
            }
        }
        IndirectListTestAPI.assertNotNull((String)"Should get an instance of java.util.stream.Stream", o);
        boolean streamFound = false;
        if (o.getClass().getEnclosingClass() != null) {
            for (Class<?> c : o.getClass().getEnclosingClass().getInterfaces()) {
                if (!"java.util.stream.Stream".equals(c.getName())) continue;
                streamFound = true;
                break;
            }
        }
        IndirectListTestAPI.assertTrue((String)"not implementing java.util.stream.Stream", (boolean)streamFound);
    }

    private Object callMethod(List list, String method, Class[] params, Object[] args) {
        try {
            Method m = list.getClass().getMethod(method, params);
            return m.invoke((Object)list, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            if (!JavaSEPlatform.CURRENT.atLeast(JavaSEPlatform.v1_8)) {
                throw new UnsupportedOperationException();
            }
            IndirectListTestAPI.fail((String)("cannot call method '" + method + "' " + ex.getMessage()));
            return null;
        }
    }
}

