/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.aggregate.AggregateSystem;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.models.readonly.ReadOnlySystem;
import org.eclipse.persistence.testing.tests.readonly.BidirectionalMMDeleteTest;
import org.eclipse.persistence.testing.tests.readonly.DeleteReadOnlyClassTestCase;
import org.eclipse.persistence.testing.tests.readonly.DeleteReadOnlyDescriptorTestCase;
import org.eclipse.persistence.testing.tests.readonly.InsertReadOnlyClassTestCase;
import org.eclipse.persistence.testing.tests.readonly.InsertReadOnlyDescriptorTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassAccessingTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassAggregateTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassDeepMergeCloneTest;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassDeleteTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassInsertTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassManyToManyTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassOneToManyTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyClassUpdateTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadOnlyDescriptorInsertTestCase;
import org.eclipse.persistence.testing.tests.readonly.ReadTest;
import org.eclipse.persistence.testing.tests.readonly.UpdateReadOnlyClassTestCase;
import org.eclipse.persistence.testing.tests.readonly.WriteableMappingReadOnlyClassTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class ReadOnlyTestModel
extends TestModel {
    public ReadOnlyTestModel() {
        this.setDescription("This model contains tests that must be verified manually.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new ReadOnlySystem());
        this.addRequiredSystem(new InheritanceSystem());
        this.addRequiredSystem(new MappingSystem());
        this.addRequiredSystem(new AggregateSystem());
    }

    public void addTests() {
        this.addTest((Test)ReadOnlyTestModel.getReadTestSuite());
        this.addTest((Test)ReadOnlyTestModel.getReadOnlyClassesTestSuite());
        this.addTest((Test)ReadOnlyTestModel.getBidirectionalMMDeleteTestSuite());
        this.addTest((Test)new WriteableMappingReadOnlyClassTest());
    }

    public static TestSuite getBidirectionalMMDeleteTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BidirectionalMMDeleteTestSuite");
        suite.setDescription("This suite tests deletion in a bidirectional MM private owned relationship.");
        suite.addTest((Test)new BidirectionalMMDeleteTest());
        return suite;
    }

    public static TestSuite getReadOnlyClassesTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadOnlyClassesTestSuite");
        suite.setDescription("This suite tests read-only classes and descriptors in the UnitOfWork.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadOnlyClassManyToManyTestCase());
        suite.addTest((Test)new ReadOnlyClassOneToManyTestCase());
        suite.addTest((Test)new ReadOnlyClassAggregateTestCase());
        suite.addTest((Test)new ReadOnlyClassInsertTestCase());
        suite.addTest((Test)new ReadOnlyClassUpdateTestCase());
        suite.addTest((Test)new ReadOnlyClassDeleteTestCase());
        suite.addTest((Test)new ReadOnlyClassAccessingTestCase());
        suite.addTest((Test)new InsertReadOnlyClassTestCase());
        suite.addTest((Test)new InsertReadOnlyDescriptorTestCase());
        suite.addTest((Test)new UpdateReadOnlyClassTestCase());
        suite.addTest((Test)new DeleteReadOnlyClassTestCase());
        suite.addTest((Test)new DeleteReadOnlyDescriptorTestCase());
        suite.addTest((Test)new ReadOnlyDescriptorInsertTestCase());
        suite.addTest((Test)new ReadOnlyClassDeepMergeCloneTest());
        return suite;
    }

    public static TestSuite getReadTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadOnlyReadTestSuite");
        suite.setDescription("This suite tests that read only was handled properly.");
        suite.addTest((Test)new ReadTest());
        return suite;
    }
}

