/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.iterable.ListIterable;


/**
 * Defines in the ORM.xml, how to map a SQL result set to an Entity view-type object. This object
 * represents more of a query then a mapping per se. May be owned by the root of the ORM.xml, an
 * Entity or a MappedSuperClass.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalSQLResultSetMapping extends ExternalForm {

	/**
	 * Adds a column result with the given name.
	 */
	void addColumnResult(int index, String name);

	/**
	 * Adds a entity result with the given name.
	 */
	void addEntityResult(int index, String className);

	/**
	 * Returns a list of column results.
	 */
	ListIterable<ExternalColumnResult> columnResults();

	/**
	 * Returns the count of all the column results.
	 */
	int columnResultsSize();

	/**
	 * Returns a list of entity result sets.
	 */
	ListIterable<ExternalEntityResult> entityResults();

	/**
	 * Returns the count of all the entity result sets.
	 */
	int entityResultsSize();

	/**
	 * Returns the column result at the given position.
	 */
	ExternalColumnResult getColumnResult(int index);

	/**
	 * Returns the description of this SQL result set mapping.
	 */
	String getDescription();

	/**
	 * Returns the entity result at the given position.
	 */
	ExternalEntityResult getEntityResult(int index);

	/**
	 * Returns the position of this SQL result set mapping within the list of SQL result set mappings
	 * owned by the parent.
	 */
	int getIndex();

	/**
	 * Returns the name of this SQL result set mapping.
	 */
	String getName();

	/**
	 * Removes the column result named
	 */
	void removeColumnResult(int index);

	/**
	 * Removes the entity result named
	 */
	void removeEntityResult(int index);

	/**
	 * Set the description
	 */
	void setDescription(String description);

	/**
	 * Sets the name of this SQL result set mapping.
	 */
	void setName(String name);
}