/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * Simple key/value pair definition for query hints defined in the ORM.xml. A named query or a
 * named, native query can have vendor specific hints associated with it to configure query properties.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalQueryHint extends ExternalForm {

	/**
	 * Returns the description of query.
	 */
	String getDescription();

	/**
	 * Returns the position of this query hint within the list of query hints owned by the parent.
	 */
	int getIndex();

	/**
	 * Returns the name of this hint.
	 */
	String getName();

	/**
	 * Returns the hint value.
	 */
	String getValue();

	/**
	 * Set the description
	 */
	void setDescription(String description);

	/**
	 * set the name.
	 */
	void setName(String name);

	/**
	 * Set the hint value.
	 */
	void setValue(String value);
}