/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * This interface and inherited behavior describe the configurable properties defined for a primary
 * key definition in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.PrimaryKey
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalPrimaryKey extends ExternalForm {

	/**
	 * Adds column with the provided column name.
	 */
	void addColumn(int index, String columnName);

	/**
	 * Returns a list of all columns defined for this primary key definition.
	 */
	ListIterable<ExternalEntityColumn> columns();

	/**
	 * Returns the count of all columns defined for this table definition.
	 */
	int columnsSize();

	/**
	 * Returns the id cache key for this primary key.
	 */
	CacheKeyType getCacheKey();

	/**
	 * Returns the column at the specified index.
	 */
	ExternalEntityColumn getColumn(int index);

	/**
	 * Returns the id validation type for this primary key.
	 */
	IdValidation getValidation();

	/**
	 * Removes all the columns owned by this primary key.
	 */
	void removeAllColumns();

	/**
	 * Remove the column at the specified index.
	 */
	void removeColumn(int index);

	/**
	 * Sets the cache key type for this primary key.
	 */
	void setCacheKey(CacheKeyType cacheKeyType);

	/**
	 * Sets the validation type for this primary key.
	 */
	void setValidation(IdValidation validation);
}