/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface describes the core definition of what an order column is as defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalOrderColumn extends ExternalForm {

	/**
	 * Returns the base for this column.
	 */
	Integer getBase();

	/**
	 * Returns the native DDL or definition string representing this column.
	 */
	String getColumnDefinition();

	/**
	 * Returns the column name.
	 */
	String getName();

	/**
	 * Returns name of the owning table for this column.
	 */
	String getTable();

	/**
	 * Indicates whether this column is contiguous.
	 */
	Boolean isContiguous();

	/**
	 * Indicates whether this column is insertable.
	 */
	Boolean isInstertable();

	/**
	 * Indicates whether this column is nullable.
	 */
	Boolean isNullable();

	/**
	 * Indicates whether this column is updatable.
	 */
	Boolean isUpdatable();

	/**
	 * Removes all metadata associated with this column from the the external form.
	 */
	void removeColumn();

	/**
	 * Removes itself from its parent.
	 */
	void removeSelf();

	/**
	 * Returns the base for this column.
	 */
	void setBase(Integer base);

	/**
	 * Sets the column definition.
	 */
	void setColumnDefinition(String columnDefinition);

	/**
	 * Sets the boolean value of whether the column is contiguous.
	 */
	void setContiguous(Boolean unique);

	/**
	 * Sets the boolean value of whether the column is insertable.
	 */
	void setInsertable(Boolean insertable);

	/**
	 * Sets the name of the column.
	 */
	void setName(String name);

	/**
	 * Sets the boolean value of whether the column is nullable.
	 */
	void setNullable(Boolean nullable);

	/**
	 * Sets the table name.
	 */
	void setTable(String table);

	/**
	 * Sets the boolean value of whether the column is updatable.
	 */
	void setUpdatable(Boolean updatable);
}