/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface describes the configurable properties for an attribute override in the ORM xml. An
 * attribute override can be declared at the root entity level or as a property of an embedded mapping.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.AttributeOverride
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
@SuppressWarnings("nls")
public interface ExternalAttributeOverride extends ExternalForm {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	String ATTRIBUTE_OVERRIDE = "attribute-override";

	/**
	 * The element name of the child text node for the description.
	 */
	String DESCRIPTION = "description";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * Retrieve the column with the given name.
	 */
	ExternalEntityColumn getColumn();

	/**
	 * Returns the description of the attribute override.
	 */
	String getDescription();

	/**
	 * Returns the index of this external form.
	 */
	int getIndex();

	/**
	 * Name of the attribute that is being overridden.
	 */
	String getName();

	/**
	 * Removes the column named
	 */
	void removeColumn(int index);

	/**
	 * Sets the column with the given name
	 */
	void setColumn(String name);

	/**
	 * Set the description
	 */
	void setDescription(String description);

	/**
	 * Sets the name of the attribute override
	 */
	void setName(String name);
}