/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * Iterable wrapper that can have its wrapped iterable changed,
 * allowing a client to change a previously-supplied iterable's
 * behavior mid-stream.
 *
 * @param <E> the type of elements returned by the iterable's iterator
 * @see #setIterable(Iterable)
 */
public class IterableWrapper<E>
	implements Iterable<E>
{
	protected volatile Iterable<E> iterable;

	public IterableWrapper(Iterable<E> iterable) {
		super();
		if (iterable == null) {
			throw new NullPointerException();
		}
		this.iterable = iterable;
	}

	@Override
	public Iterator<E> iterator() {
		return this.iterable.iterator();
	}

	public void setIterable(Iterable<E> iterable) {
		if (iterable == null) {
			throw new NullPointerException();
		}
		this.iterable = iterable;
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.iterable);
	}
}