/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.enumeration;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.enumeration.EmptyEnumeration;

public class EmptyEnumerationTests
extends TestCase {
    public EmptyEnumerationTests(String name) {
        super(name);
    }

    public void testHasMoreElements() {
        int i = 0;
        Enumeration stream = EmptyEnumeration.instance();
        while (stream.hasMoreElements()) {
            stream.nextElement();
            ++i;
        }
        EmptyEnumerationTests.assertEquals((int)0, (int)i);
    }

    public void testNextElement() {
        Enumeration stream = EmptyEnumeration.instance();
        while (stream.hasMoreElements()) {
            EmptyEnumerationTests.fail((String)("bogus element: " + stream.nextElement()));
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Enumeration stream = EmptyEnumeration.instance();
        Object element = null;
        while (stream.hasMoreElements()) {
            element = stream.nextElement();
        }
        try {
            element = stream.nextElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyEnumerationTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
    }
}

