/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.tools.db.driver.AbstractWorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.CatalogStrategy;
import org.eclipse.persistence.tools.db.driver.FoldingStrategy;
import org.eclipse.persistence.tools.db.driver.NoCatalogStrategy;
import org.eclipse.persistence.tools.db.driver.NonFoldingStrategy;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapterFactory;
import org.eclipse.persistence.tools.gen.db.Database;
import org.eclipse.persistence.tools.gen.db.DatabaseObject;
import org.eclipse.persistence.tools.gen.db.Schema;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.SystemTools;

class MySQL
extends AbstractWorkbenchDriverAdapter {
    private int lower_case_table_names = -1;
    private Boolean ANSI_QUOTES = null;
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_', '$'};
    private static final char BACKTICK = '`';

    MySQL(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new NoCatalogStrategy();
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return NonFoldingStrategy.instance();
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        names.add(this.database.getName());
    }

    @Override
    boolean characterIsRegularNameStart(char c) {
        return Character.isDigit(c) || super.characterIsRegularNameStart(c);
    }

    @Override
    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    @Override
    String delimitName(String name) {
        return StringTools.delimit((String)name, (char)'`');
    }

    @Override
    boolean identifierIsDelimited(String identifier) {
        return StringTools.isDelimited((String)identifier, (char)'`') || StringTools.isQuoted((String)identifier) && this.doubleQuoteIsIdentifierDelimiter();
    }

    @Override
    boolean regularNamesMatch(String name1, String name2) {
        return this.tableNamesAreCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    @Override
    public Schema selectSchemaForIdentifier(Iterable<Schema> schemata, String identifier) {
        return this.tableNamesAreCaseSensitive() ? this.selectDatabaseObjectForIdentifierRespectCase(schemata, identifier) : super.selectSchemaForIdentifier(schemata, identifier);
    }

    @Override
    public Table selectTableForIdentifier(Iterable<Table> tables, String identifier) {
        return this.tableNamesAreCaseSensitive() ? this.selectDatabaseObjectForIdentifierRespectCase(tables, identifier) : super.selectTableForIdentifier(tables, identifier);
    }

    private <T extends DatabaseObject> T selectDatabaseObjectForIdentifierRespectCase(Iterable<T> databaseObjects, String identifier) {
        return this.selectDatabaseObjectNamedRespectCase(databaseObjects, this.convertIdentifierToName(identifier));
    }

    @Override
    <T extends DatabaseObject> T selectDatabaseObjectNamed(Iterable<T> databaseObjects, String name) {
        return this.selectDatabaseObjectNamedIgnoreCase(databaseObjects, name);
    }

    private boolean tableNamesAreCaseSensitive() {
        return false;
    }

    private int buildLowerCaseTableNames() {
        int dbValue = this.getLowerCaseTableNamesFromDatabase();
        return dbValue != -1 ? dbValue : this.getLowerCaseTableNamesFromOS();
    }

    private int getLowerCaseTableNamesFromDatabase() {
        if (this.getConnectionProfile().isDisconnected()) {
            return -1;
        }
        List<Map<String, Object>> rows = this.execute("SHOW VARIABLES LIKE 'lower\\_case\\_table\\_names'");
        if (rows.isEmpty()) {
            return -1;
        }
        Map<String, Object> row = rows.get(0);
        if (ObjectTools.equals((Object)row.get("Variable_name"), (Object)"lower_case_table_names")) {
            return Integer.valueOf((String)row.get("Value"));
        }
        return -1;
    }

    private int getLowerCaseTableNamesFromOS() {
        if (SystemTools.osIsMac()) {
            return 2;
        }
        if (SystemTools.osIsWindows()) {
            return 1;
        }
        return 0;
    }

    private boolean doubleQuoteIsIdentifierDelimiter() {
        return this.getANSIQuotes();
    }

    private Boolean getANSIQuotes() {
        if (this.ANSI_QUOTES == null) {
            this.ANSI_QUOTES = this.buildANSIQuotes();
        }
        return this.ANSI_QUOTES;
    }

    private Boolean buildANSIQuotes() {
        Boolean dbValue = this.getANSIQuotesFromDatabase();
        return dbValue != null ? dbValue : Boolean.FALSE;
    }

    private Boolean getANSIQuotesFromDatabase() {
        if (this.getConnectionProfile().isDisconnected()) {
            return null;
        }
        List<Map<String, Object>> rows = this.execute("SELECT @@SESSION.sql_mode");
        if (rows.isEmpty()) {
            return null;
        }
        Map<String, Object> row = rows.get(0);
        String sql_mode = (String)row.get("@@SESSION.sql_mode");
        if (sql_mode == null) {
            return null;
        }
        Object[] modes = sql_mode.split(",");
        return ArrayTools.contains((Object[])modes, (Object)"ANSI_QUOTES");
    }

    static class Factory
    implements WorkbenchDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"MySQL"};

        Factory() {
        }

        @Override
        public String[] getSupportedVendors() {
            return VENDORS;
        }

        @Override
        public WorkbenchDriverAdapter buildAdapter(Database database) {
            return new MySQL(database);
        }
    }
}

