/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.filter;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.filter.Filter;

public abstract class CompoundFilter<T>
implements Filter<T>,
Cloneable,
Serializable {
    protected Filter<T>[] filters;
    private static final long serialVersionUID = 1L;

    protected CompoundFilter(Filter<T> ... filters) {
        if (filters == null) {
            throw new NullPointerException();
        }
        this.filters = filters;
    }

    public Filter<T>[] getFilters() {
        return this.filters;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompoundFilter)) {
            return false;
        }
        CompoundFilter other = (CompoundFilter)o;
        return Arrays.equals(this.filters, other.filters);
    }

    public int hashCode() {
        return Arrays.hashCode(this.filters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, this);
        sb.append('(');
        Filter<T>[] filterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter<T> filter = filterArray[n2];
            sb.append(filter);
            sb.append(' ');
            sb.append(this.operatorString());
            sb.append(' ');
            ++n2;
        }
        if (this.filters.length > 0) {
            sb.setLength(sb.length() - this.operatorString().length() - 2);
        }
        sb.append(')');
        return sb.toString();
    }

    protected abstract String operatorString();
}

