/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.BitTools;
import org.eclipse.persistence.tools.utility.ByteArrayTools;
import org.eclipse.persistence.tools.utility.CharacterTools;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.transformer.Transformer;
import org.eclipse.persistence.tools.utility.transformer.TransformerAdapter;

public final class CharArrayTools {
    public static final char[] CR = StringTools.CR.toCharArray();
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final char[][] EMPTY_CHAR_ARRAY_ARRAY = new char[0][0];
    public static final Transformer<char[], char[]> CAPITALIZER = new Capitalizer();
    public static final Transformer<char[], char[]> UNCAPITALIZER = new Uncapitalizer();
    public static final Filter<char[]> NON_BLANK_FILTER = new NonBlankFilter();
    public static final char[] EMPTY_JAVA_STRING_LITERAL = "\"\"".toCharArray();
    public static final Transformer<char[], char[]> JAVA_STRING_LITERAL_TRANSFORMER = new JavaStringLiteralTransformer();
    public static final Transformer<char[], char[]> JAVA_STRING_LITERAL_CONTENT_TRANSFORMER = new JavaStringLiteralContentTransformer();
    public static final char[] EMPTY_DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE = "\"\"".toCharArray();
    public static final char[] EMPTY_SINGLE_QUOTED_XML_ATTRIBUTE_VALUE = "''".toCharArray();
    public static final char[] EMPTY_XML_ATTRIBUTE_VALUE = "\"\"".toCharArray();
    public static final char[] XML_ELEMENT_CDATA_START = "<![CDATA[".toCharArray();
    public static final char[] XML_ELEMENT_CDATA_END = "]]>".toCharArray();
    public static final char[] EMPTY_XML_ELEMENT_CDATA = "<![CDATA[]]>".toCharArray();
    public static final char[] XML_QUOTE = "&quot;".toCharArray();
    public static final char[] XML_AMP = "&amp;".toCharArray();
    public static final char[] XML_APOS = "&apos;".toCharArray();
    public static final char[] XML_LT = "&lt;".toCharArray();
    public static final char[] XML_GT = "&gt;".toCharArray();
    public static final Transformer<char[], char[]> XML_ATTRIBUTE_VALUE_TRANSFORMER = new XmlAttributeValueTransformer();
    public static final Transformer<char[], char[]> DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER = new DoubleQuotedXmlAttributeValueTransformer();
    public static final Transformer<char[], char[]> XML_DOUBLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER = new XmlDoubleQuotedAttributeValueContentTransformer();
    public static final Transformer<char[], char[]> SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER = new SingleQuotedXmlAttributeValueTransformer();
    public static final Transformer<char[], char[]> XML_SINGLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER = new XmlSingleQuotedAttributeValueContentTransformer();
    public static final Transformer<char[], char[]> XML_ELEMENT_TEXT_TRANSFORMER = new XmlElementTextTransformer();
    public static final Transformer<char[], char[]> XML_ELEMENT_CDATA_TRANSFORMER = new XmlElementCDATATransformer();
    public static final Transformer<char[], char[]> XML_ELEMENT_CDATA_CONTENT_TRANSFORMER = new XmlElementCDATAContentTransformer();

    public static char last(char[] string) {
        return string[string.length - 1];
    }

    public static String concatenate(char[] ... strings) {
        int stringLength = 0;
        char[][] cArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            char[] string = cArray[n2];
            stringLength += string.length;
            ++n2;
        }
        StringBuilder sb = new StringBuilder(stringLength);
        char[][] cArray2 = strings;
        int n3 = strings.length;
        n = 0;
        while (n < n3) {
            char[] string = cArray2[n];
            sb.append(string);
            ++n;
        }
        return sb.toString();
    }

    public static String concatenate(Iterable<char[]> strings) {
        return CharArrayTools.concatenate(strings.iterator());
    }

    public static String concatenate(Iterator<char[]> strings) {
        StringBuilder sb = new StringBuilder();
        while (strings.hasNext()) {
            sb.append(strings.next());
        }
        return sb.toString();
    }

    public static char[] center(char[] string, int length) {
        return CharArrayTools.center(string, length, ' ');
    }

    public static char[] center(char[] string, int length, char c) {
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return ArrayTools.subArray_(string, stringLength - length >> 1, length);
        }
        char[] result = new char[length];
        int begin = length - stringLength >> 1;
        Arrays.fill(result, 0, begin, c);
        System.arraycopy(string, 0, result, begin, stringLength);
        Arrays.fill(result, begin + stringLength, length, c);
        return result;
    }

    public static char[] pad(char[] string, int length) {
        return CharArrayTools.pad(string, length, ' ');
    }

    public static char[] pad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return CharArrayTools.pad(string, length, c, stringLength);
    }

    public static char[] fit(char[] string, int length) {
        return CharArrayTools.fit(string, length, ' ');
    }

    public static char[] fit(char[] string, int length, char c) {
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return ArrayTools.subArray_(string, 0, length);
        }
        return CharArrayTools.pad(string, length, c, stringLength);
    }

    private static char[] pad(char[] string, int length, char c, int stringLength) {
        char[] result = new char[length];
        System.arraycopy(string, 0, result, 0, stringLength);
        Arrays.fill(result, stringLength, length, c);
        return result;
    }

    public static char[] zeroPad(char[] string, int length) {
        return CharArrayTools.frontPad(string, length, '0');
    }

    public static char[] frontPad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return CharArrayTools.frontPad(string, length, c, stringLength);
    }

    public static char[] zeroFit(char[] string, int length) {
        return CharArrayTools.frontFit(string, length, '0');
    }

    public static char[] frontFit(char[] string, int length, char c) {
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return ArrayTools.subArray_(string, stringLength - length, length);
        }
        return CharArrayTools.frontPad(string, length, c, stringLength);
    }

    private static char[] frontPad(char[] string, int length, char c, int stringLength) {
        char[] result = new char[length];
        int padLength = length - stringLength;
        System.arraycopy(string, 0, result, padLength, stringLength);
        Arrays.fill(result, 0, padLength, c);
        return result;
    }

    public static char[] separate(char[] string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length;
        return stringLength <= segmentSize ? string : CharArrayTools.separate(string, separator, segmentSize, stringLength);
    }

    private static char[] separate(char[] string, char separator, int segmentSize, int stringLength) {
        int resultLen = stringLength + stringLength / segmentSize;
        if (stringLength % segmentSize == 0) {
            --resultLen;
        }
        char[] result = new char[resultLen];
        int j = 0;
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (segCount == segmentSize) {
                result[j++] = separator;
                segCount = 0;
            }
            ++segCount;
            result[j++] = c;
            ++i;
        }
        return result;
    }

    public static char[] quote(char[] string) {
        return CharArrayTools.delimit(string, '\"');
    }

    public static char[] delimit(char[] string, char delimiter) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength + 2);
        StringBuilderTools.delimit(sb, string, delimiter, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] delimit(char[] string, char[] delimiter) {
        return CharArrayTools.delimit(string, delimiter, delimiter.length);
    }

    static char[] delimit(char[] string, char[] delimiter, int delimiterLength) {
        switch (delimiterLength) {
            case 0: {
                return string;
            }
            case 1: {
                return CharArrayTools.delimit(string, delimiter[0]);
            }
        }
        return CharArrayTools.delimit_(string, delimiter, delimiterLength);
    }

    private static char[] delimit_(char[] string, char[] delimiter, int delimiterLength) {
        int stringLength = string.length;
        char[] result = new char[stringLength + 2 * delimiterLength];
        System.arraycopy(delimiter, 0, result, 0, delimiterLength);
        System.arraycopy(string, 0, result, delimiterLength, stringLength);
        System.arraycopy(delimiter, 0, result, stringLength + delimiterLength, delimiterLength);
        return result;
    }

    public static boolean isQuoted(char[] string) {
        return CharArrayTools.isDelimited(string, '\"');
    }

    public static boolean isParenthetical(char[] string) {
        return CharArrayTools.isDelimited(string, '(', ')');
    }

    public static boolean isBracketed(char[] string) {
        return CharArrayTools.isDelimited(string, '[', ']');
    }

    public static boolean isBraced(char[] string) {
        return CharArrayTools.isDelimited(string, '{', '}');
    }

    public static boolean isChevroned(char[] string) {
        return CharArrayTools.isDelimited(string, '<', '>');
    }

    public static boolean isDelimited(char[] string, char c) {
        return CharArrayTools.isDelimited(string, c, c);
    }

    public static boolean isDelimited(char[] string, char start, char end) {
        int stringLength = string.length;
        return stringLength < 2 ? false : CharArrayTools.isDelimited(string, start, end, stringLength);
    }

    private static boolean isDelimited(char[] string, char start, char end, int stringLength) {
        return string[0] == start && string[stringLength - 1] == end;
    }

    public static char[] undelimit(char[] string) {
        int stringLength = string.length;
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(resultLength);
        StringBuilderTools.undelimit_(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] undelimit(char[] string, int count) {
        if (count == 0) {
            return string;
        }
        int resultLength = string.length - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        return CharArrayTools.undelimit(string, count, resultLength);
    }

    private static char[] undelimit(char[] string, int count, int resultLength) {
        return ArrayTools.subArray_(string, count, resultLength);
    }

    public static char[] removeFirstOccurrence(char[] string, char c) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            return string;
        }
        int last = string.length - 1;
        char[] result = new char[last];
        if (index == 0) {
            System.arraycopy(string, 1, result, 0, last);
        } else if (index == last) {
            System.arraycopy(string, 0, result, 0, last);
        } else {
            System.arraycopy(string, 0, result, 0, index);
            System.arraycopy(string, index + 1, result, index, last - index);
        }
        return result;
    }

    public static char[] removeAllOccurrences(char[] string, char c) {
        int first = ArrayTools.indexOf(string, c);
        return first == -1 ? string : CharArrayTools.removeAllOccurrences(string, c, first);
    }

    private static char[] removeAllOccurrences(char[] string, char c, int first) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.removeAllOccurrences(sb, string, c, first, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] removeAllSpaces(char[] string) {
        return CharArrayTools.removeAllOccurrences(string, ' ');
    }

    public static char[] removeAllWhitespace(char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        return first == -1 ? string : CharArrayTools.removeAllWhitespace(string, first);
    }

    public static int indexOfWhitespace(char[] string) {
        int stringLength = string.length;
        int i = 0;
        while (i < stringLength) {
            if (Character.isWhitespace(string[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static char[] removeAllWhitespace(char[] string, int first) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.removeAllWhitespace(sb, string, first, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] compressWhitespace(char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        return first == -1 ? string : CharArrayTools.compressWhitespace(string, first);
    }

    private static char[] compressWhitespace(char[] string, int first) {
        int stringLength = string.length;
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.compressWhitespace(sb, string, first, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static int commonPrefixLength(char[] s1, char[] s2) {
        return CharArrayTools.commonPrefixLength(s1, s2, Math.min(s1.length, s2.length));
    }

    public static int commonPrefixLength(char[] s1, char[] s2, int max) {
        int i = 0;
        while (i < max) {
            if (s1[i] != s2[i]) {
                return i;
            }
            ++i;
        }
        return max;
    }

    public static char[] capitalize(char[] string) {
        int stringLength = string.length;
        return stringLength == 0 || Character.isUpperCase(string[0]) ? string : CharArrayTools.capitalize(string, stringLength);
    }

    private static char[] capitalize(char[] string, int stringLength) {
        char[] result = new char[stringLength];
        result[0] = Character.toUpperCase(string[0]);
        System.arraycopy(string, 1, result, 1, stringLength - 1);
        return result;
    }

    public static char[] uncapitalize(char[] string) {
        int stringLength = string.length;
        return CharArrayTools.needNotBeUncapitalized(string, stringLength) ? string : CharArrayTools.uncapitalize(string, stringLength);
    }

    public static boolean needNotBeUncapitalized(char[] string, int stringLength) {
        if (stringLength == 0) {
            return true;
        }
        if (Character.isLowerCase(string[0])) {
            return true;
        }
        return stringLength > 1 && Character.isUpperCase(string[1]) && Character.isUpperCase(string[0]);
    }

    private static char[] uncapitalize(char[] string, int stringLength) {
        char[] result = new char[stringLength];
        result[0] = Character.toLowerCase(string[0]);
        System.arraycopy(string, 1, result, 1, stringLength - 1);
        return result;
    }

    public static boolean isBlank(char[] string) {
        if (string == null) {
            return true;
        }
        int stringLength = string.length;
        if (stringLength == 0) {
            return true;
        }
        return CharArrayTools.isBlank(string, stringLength);
    }

    private static boolean isBlank(char[] string, int stringLength) {
        int i = stringLength;
        while (i-- > 0) {
            if (Character.isWhitespace(string[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(char[] string) {
        return !CharArrayTools.isBlank(string);
    }

    public static boolean equalsIgnoreCase(char[] s1, char[] s2) {
        return s1 == null ? s2 == null : s2 != null && CharArrayTools.equalsIgnoreCase_(s1, s2);
    }

    private static boolean equalsIgnoreCase_(char[] s1, char[] s2) {
        int stringLength = s1.length;
        if (stringLength != s2.length) {
            return false;
        }
        int i = stringLength;
        while (i-- > 0) {
            if (CharacterTools.equalsIgnoreCase(s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(char[] string, char[] prefix) {
        int prefixLength = prefix.length;
        if (string.length < prefixLength) {
            return false;
        }
        int i = prefixLength;
        while (i-- > 0) {
            if (CharacterTools.equalsIgnoreCase(string[i], prefix[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isUppercase(char[] string) {
        return string.length != 0 && StringTools.isUppercase_(new String(string));
    }

    public static boolean isLowercase(char[] string) {
        return string.length != 0 && StringTools.isLowercase_(new String(string));
    }

    public static byte[] convertHexStringToByteArray(char[] hexString) {
        int hexStringLength = hexString.length;
        if (hexStringLength == 0) {
            return ByteArrayTools.EMPTY_BYTE_ARRAY;
        }
        if (BitTools.isOdd(hexStringLength)) {
            throw new IllegalArgumentException("Odd-sized hexadecimal string: " + new String(hexString) + " (" + hexStringLength + " characters)");
        }
        return CharArrayTools.convertHexStringToByteArray(hexString, hexStringLength);
    }

    private static byte[] convertHexStringToByteArray(char[] hexString, int hexStringLength) {
        byte[] bytes = new byte[BitTools.half(hexStringLength)];
        int bi = bytes.length - 1;
        int si = hexStringLength - 2;
        while (bi >= 0) {
            byte digit1 = (byte)Character.digit(hexString[si], 16);
            if (digit1 == -1) {
                throw new IllegalArgumentException(CharArrayTools.buildIllegalHexCharMessage(hexString, si));
            }
            byte digit2 = (byte)Character.digit(hexString[si + 1], 16);
            if (digit2 == -1) {
                throw new IllegalArgumentException(CharArrayTools.buildIllegalHexCharMessage(hexString, si + 1));
            }
            bytes[bi] = (byte)((digit1 << 4) + digit2);
            --bi;
            si -= 2;
        }
        return bytes;
    }

    private static String buildIllegalHexCharMessage(char[] hexString, int index) {
        return StringTools.buildIllegalHexCharMessage(new String(hexString), index);
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString) {
        int stringLength = camelCaseString.length;
        return stringLength == 0 ? camelCaseString : CharArrayTools.convertCamelCaseToAllCaps_(camelCaseString, stringLength);
    }

    private static char[] convertCamelCaseToAllCaps_(char[] camelCaseString, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength + stringLength / 4);
        StringBuilderTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString, int maxLength) {
        if (maxLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int stringLength = camelCaseString.length;
        return stringLength == 0 ? camelCaseString : CharArrayTools.convertCamelCaseToAllCaps(camelCaseString, maxLength, stringLength);
    }

    private static char[] convertCamelCaseToAllCaps(char[] camelCaseString, int maxLength, int stringLength) {
        StringBuilder sb = new StringBuilder(maxLength);
        StringBuilderTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertAllCapsToCamelCase(char[] allCapsString) {
        return CharArrayTools.convertAllCapsToCamelCase(allCapsString, true);
    }

    public static char[] convertAllCapsToCamelCase(char[] allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length;
        return stringLength == 0 ? allCapsString : CharArrayTools.convertAllCapsToCamelCase(allCapsString, capitalizeFirstLetter, stringLength);
    }

    private static char[] convertAllCapsToCamelCase(char[] allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToJavaStringLiteral(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_JAVA_STRING_LITERAL;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToJavaStringLiteral(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToJavaStringLiteralContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlAttributeValue(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_XML_ATTRIBUTE_VALUE;
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToXmlAttributeValue(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToDoubleQuotedXmlAttributeValue(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE;
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToDoubleQuotedXmlAttributeValueContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 10);
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToSingleQuotedXmlAttributeValue(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_SINGLE_QUOTED_XML_ATTRIBUTE_VALUE;
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToSingleQuotedXmlAttributeValueContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 10);
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlElementText(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return string;
        }
        StringBuilder sb = new StringBuilder(stringLength + 8);
        StringBuilderTools.convertToXmlElementText(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlElementCDATA(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_XML_ELEMENT_CDATA;
        }
        StringBuilder sb = new StringBuilder(stringLength + EMPTY_XML_ELEMENT_CDATA.length + 6);
        StringBuilderTools.convertToXmlElementCDATA(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static char[] convertToXmlElementCDATAContent(char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        return StringBuilderTools.convertToCharArray(sb);
    }

    private CharArrayTools() {
        throw new UnsupportedOperationException();
    }

    static class Capitalizer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        Capitalizer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.capitalize(string);
        }

        private Object readResolve() {
            return CAPITALIZER;
        }
    }

    public static class CharArrayDelimiter
    extends TransformerAdapter<char[], char[]> {
        private final char[] delimiter;
        private final int delimiterLength;

        public CharArrayDelimiter(char[] delimiter) {
            this.delimiter = delimiter;
            this.delimiterLength = delimiter.length;
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.delimit(string, this.delimiter, this.delimiterLength);
        }
    }

    public static class CharDelimiter
    extends TransformerAdapter<char[], char[]> {
        private final char delimiter;

        public CharDelimiter(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.delimit(string, this.delimiter);
        }
    }

    static class DoubleQuotedXmlAttributeValueTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        DoubleQuotedXmlAttributeValueTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToDoubleQuotedXmlAttributeValue(string);
        }

        private Object readResolve() {
            return DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    static class JavaStringLiteralContentTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        JavaStringLiteralContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToJavaStringLiteralContent(string);
        }

        private Object readResolve() {
            return JAVA_STRING_LITERAL_CONTENT_TRANSFORMER;
        }
    }

    static class JavaStringLiteralTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        JavaStringLiteralTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToJavaStringLiteral(string);
        }

        private Object readResolve() {
            return JAVA_STRING_LITERAL_TRANSFORMER;
        }
    }

    static class NonBlankFilter
    extends Filter.Adapter<char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        NonBlankFilter() {
        }

        @Override
        public boolean accept(char[] string) {
            return CharArrayTools.isNotBlank(string);
        }

        private Object readResolve() {
            return NON_BLANK_FILTER;
        }
    }

    static class SingleQuotedXmlAttributeValueTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        SingleQuotedXmlAttributeValueTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToSingleQuotedXmlAttributeValue(string);
        }

        private Object readResolve() {
            return SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    static class Uncapitalizer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        Uncapitalizer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.uncapitalize(string);
        }

        private Object readResolve() {
            return UNCAPITALIZER;
        }
    }

    static class XmlAttributeValueTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        XmlAttributeValueTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlAttributeValue(string);
        }

        private Object readResolve() {
            return XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    static class XmlDoubleQuotedAttributeValueContentTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        XmlDoubleQuotedAttributeValueContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToDoubleQuotedXmlAttributeValueContent(string);
        }

        private Object readResolve() {
            return XML_DOUBLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
        }
    }

    static class XmlElementCDATAContentTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementCDATAContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlElementCDATAContent(string);
        }

        private Object readResolve() {
            return XML_ELEMENT_CDATA_CONTENT_TRANSFORMER;
        }
    }

    static class XmlElementCDATATransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementCDATATransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlElementCDATA(string);
        }

        private Object readResolve() {
            return XML_ELEMENT_CDATA_TRANSFORMER;
        }
    }

    static class XmlElementTextTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementTextTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToXmlElementText(string);
        }

        private Object readResolve() {
            return XML_ELEMENT_TEXT_TRANSFORMER;
        }
    }

    static class XmlSingleQuotedAttributeValueContentTransformer
    extends TransformerAdapter<char[], char[]>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        XmlSingleQuotedAttributeValueContentTransformer() {
        }

        @Override
        public char[] transform(char[] string) {
            return CharArrayTools.convertToSingleQuotedXmlAttributeValueContent(string);
        }

        private Object readResolve() {
            return XML_SINGLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
        }
    }
}

