/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinTable;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.ElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinTable;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectCollectionMapping;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class AssociationOverride
extends AbstractExternalForm
implements ExternalAssociationOverride {
    static final String ASSOCIATION_OVERRIDE = "association-override";
    static final String DESCRIPTION = "description";
    static final String NAME = "name";
    private int index;

    AssociationOverride(ElementCollectionMapping parent, int index) {
        super(parent);
        this.index = index;
    }

    AssociationOverride(EmbeddedMapping parent, int index) {
        super(parent);
        this.index = index;
    }

    AssociationOverride(Entity parent, int index) {
        super(parent);
        this.index = index;
    }

    AssociationOverride(ObjectCollectionMapping parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public void addJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    public final void addJoinTable(String tableName) {
        JoinTable joinTable = this.buildJoinTable();
        joinTable.addSelf();
        joinTable.setName(tableName);
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        names.add("join-column");
        names.add("join-table");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, index);
    }

    private JoinTable buildJoinTable() {
        return new JoinTable(this);
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return ASSOCIATION_OVERRIDE;
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        Element element = this.getChild("join-column", index);
        if (element != null) {
            return this.buildJoinColumn(index);
        }
        return null;
    }

    @Override
    public final ExternalJoinTable getJoinTable() {
        Element element = this.getChild("join-table");
        if (element != null) {
            return this.buildJoinTable();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public ListIterable<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public void setName(String name) {
        this.setAttribute(NAME, name);
    }
}

